/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.account.exception.NoSuchGroupException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelService;
import com.liferay.account.service.AccountEntryService;
import com.liferay.account.service.AccountEntryUserRelService;
import com.liferay.account.service.AccountGroupRelService;
import com.liferay.account.service.AccountGroupService;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.util.CommerceAccountHelper;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.headless.commerce.admin.account.internal.odata.entity.v1_0.AccountEntityModel;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountResourceImpl;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountMemberUtil;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountOrganizationUtil;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountResource;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountResource.class})
public class AccountResourceImpl
extends BaseAccountResourceImpl {
    private static final int _ACCOUNT_TYPE_BUSINESS = 2;
    private static final int _ACCOUNT_TYPE_GUEST = 0;
    private static final int _ACCOUNT_TYPE_PERSONAL = 1;
    private static final Log _log = LogFactoryUtil.getLog(AccountResourceImpl.class);
    private static final EntityModel _entityModel = new AccountEntityModel();
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountDTOConverter)")
    private DTOConverter<AccountEntry, Account> _accountDTOConverter;
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountEntryOrganizationRelService _accountEntryOrganizationRelService;
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private AccountEntryUserRelService _accountEntryUserRelService;
    @Reference
    private AccountGroupRelService _accountGroupRelService;
    @Reference
    private AccountGroupService _accountGroupService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CountryService _countryService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RegionLocalService _regionLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Response deleteAccount(Long id) throws Exception {
        this._accountEntryService.deleteAccountEntry(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this._accountEntryService.deleteAccountEntry(accountEntry.getAccountEntryId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountGroupByExternalReferenceCodeAccount(String accountExternalReferenceCode, String externalReferenceCode) throws Exception {
        AccountGroup accountGroup = this._accountGroupService.fetchAccountGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountGroup == null) {
            throw new NoSuchGroupException("Unable to find account group with external reference code " + externalReferenceCode);
        }
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), accountExternalReferenceCode);
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find Account with external reference code: " + accountExternalReferenceCode);
        }
        AccountGroupRel accountGroupRel = this._accountGroupRelService.fetchAccountGroupRel(accountGroup.getAccountGroupId(), AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        this._accountGroupRelService.deleteAccountGroupRel(accountGroupRel.getAccountGroupRelId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Account getAccount(Long id) throws Exception {
        return (Account)this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)GetterUtil.getLong((Object)id), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Account getAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        return (Account)this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntry.getAccountEntryId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<Account> getAccountsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)AccountEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toAccount(this._accountEntryLocalService.getAccountEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Response patchAccount(Long id, Account account) throws Exception {
        this._updateAccount(id, account);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountByExternalReferenceCode(String externalReferenceCode, Account account) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this._updateAccount(accountEntry.getAccountEntryId(), account);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Account postAccount(Account account) throws Exception {
        Map customFields;
        AccountEntry accountEntry = this._accountEntryService.addOrUpdateAccountEntry(account.getExternalReferenceCode(), this.contextUser.getUserId(), 0L, account.getName(), null, null, this._getEmailAddress(account, null), null, account.getTaxId(), GetterUtil.get((String)this._toAccountEntryType(account.getType()), (String)"person"), this._toAccountEntryStatus(GetterUtil.getBoolean((Object)account.getActive(), (boolean)true)).intValue(), this._serviceContextHelper.getServiceContext());
        if (this._isValidId(account.getDefaultBillingAccountAddressId())) {
            this._accountEntryLocalService.updateDefaultBillingAddressId(accountEntry.getAccountEntryId(), account.getDefaultBillingAccountAddressId().longValue());
        }
        if (this._isValidId(account.getDefaultShippingAccountAddressId())) {
            this._accountEntryLocalService.updateDefaultShippingAddressId(accountEntry.getAccountEntryId(), account.getDefaultShippingAccountAddressId().longValue());
        }
        if ((customFields = account.getCustomFields()) != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), AccountEntry.class, (long)accountEntry.getPrimaryKey(), (Map)customFields);
        }
        this._updateNestedResources(account, accountEntry, this._serviceContextHelper.getServiceContext());
        return (Account)this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntry.getAccountEntryId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Response postAccountByExternalReferenceCodeLogo(String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this.updateAccountLogo(accountEntry, multipartBody);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response postAccountGroupByExternalReferenceCodeAccount(String externalReferenceCode, Account account) throws Exception {
        AccountGroup accountGroup = this._accountGroupService.fetchAccountGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountGroup == null) {
            throw new NoSuchGroupException("Unable to find account group with external reference code " + externalReferenceCode);
        }
        AccountEntry accountEntry = null;
        if (account.getId() != null) {
            accountEntry = this._accountEntryService.fetchAccountEntry(account.getId().longValue());
        } else if (account.getExternalReferenceCode() != null) {
            accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), account.getExternalReferenceCode());
        }
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find Account with external reference code: " + account.getExternalReferenceCode());
        }
        this._accountGroupRelService.addAccountGroupRel(accountGroup.getAccountGroupId(), AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response postAccountLogo(Long id, MultipartBody multipartBody) throws Exception {
        this.updateAccountLogo(this._accountEntryLocalService.getAccountEntry(id.longValue()), multipartBody);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    public void updateAccountLogo(AccountEntry accountEntry, MultipartBody multipartBody) throws IOException, PortalException {
        this._accountEntryService.updateAccountEntry(accountEntry.getAccountEntryId(), accountEntry.getParentAccountEntryId(), accountEntry.getName(), accountEntry.getDescription(), true, StringUtil.split((String)accountEntry.getDomains()), accountEntry.getEmailAddress(), multipartBody.getBinaryFileAsBytes("logo"), accountEntry.getTaxIdNumber(), accountEntry.getStatus(), this._serviceContextHelper.getServiceContext(accountEntry.getAccountEntryGroupId()));
    }

    private String _getEmailAddress(Account account, AccountEntry accountEntry) {
        String[] emailAddresses = new String[]{};
        if (account.getEmailAddresses() != null) {
            emailAddresses = account.getEmailAddresses();
        }
        if (emailAddresses.length > 0) {
            return emailAddresses[0];
        }
        if (accountEntry == null) {
            return "";
        }
        return accountEntry.getEmailAddress();
    }

    private long _getRegionId(Country country, AccountAddress accountAddress) throws Exception {
        if (Validator.isNull((String)accountAddress.getRegionISOCode()) || country == null) {
            return 0L;
        }
        Region region = this._regionLocalService.fetchRegion(country.getCountryId(), accountAddress.getRegionISOCode());
        if (region == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to find region with ISO code ", accountAddress.getRegionISOCode(), " for country ", country.getCountryId()}));
            }
            return 0L;
        }
        return region.getRegionId();
    }

    private boolean _isValidId(Long value) {
        return value != null && value > 0L;
    }

    private Account _toAccount(AccountEntry accountEntry) throws Exception {
        if (accountEntry == null) {
            return null;
        }
        return (Account)this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntry.getAccountEntryId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private Integer _toAccountEntryStatus(Boolean active) {
        if (active == null) {
            return -1;
        }
        if (active.booleanValue()) {
            return 0;
        }
        return 5;
    }

    private String _toAccountEntryType(int commerceAccountType) {
        if (commerceAccountType == 2) {
            return "business";
        }
        if (commerceAccountType == 0) {
            return "guest";
        }
        if (commerceAccountType == 1) {
            return "person";
        }
        return null;
    }

    private AccountEntry _updateAccount(Long id, Account account) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(id.longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(accountEntry.getAccountEntryGroupId());
        accountEntry.setDefaultBillingAddressId(GetterUtil.getLong((Object)account.getDefaultBillingAccountAddressId(), (long)accountEntry.getDefaultBillingAddressId()));
        accountEntry.setDefaultShippingAddressId(GetterUtil.getLong((Object)account.getDefaultShippingAccountAddressId(), (long)accountEntry.getDefaultShippingAddressId()));
        accountEntry.setEmailAddress(this._getEmailAddress(account, accountEntry));
        accountEntry.setName(account.getName());
        accountEntry.setTaxIdNumber(GetterUtil.get((String)account.getTaxId(), (String)accountEntry.getTaxIdNumber()));
        accountEntry.setStatus(this._toAccountEntryStatus(GetterUtil.getBoolean((Object)account.getActive(), (boolean)true)).intValue());
        this._accountEntryService.updateAccountEntry(accountEntry);
        Map customFields = account.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), AccountEntry.class, (long)accountEntry.getPrimaryKey(), (Map)customFields);
        }
        this._updateNestedResources(account, accountEntry, serviceContext);
        return accountEntry;
    }

    private AccountEntry _updateNestedResources(Account account, AccountEntry accountEntry, ServiceContext serviceContext) throws Exception {
        AccountOrganization[] accountOrganizations;
        AccountMember[] accountMembers;
        AccountAddress[] accountAddresses = account.getAccountAddresses();
        if (accountAddresses != null) {
            for (AccountAddress accountAddress : accountAddresses) {
                Country country = this._countryService.fetchCountryByA2(accountEntry.getCompanyId(), accountAddress.getCountryISOCode());
                if (country == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to import account address with ", "country ISO code ", account.getName(), " and account name ", accountAddress.getCountryISOCode()}));
                    continue;
                }
                long accountAddressId = GetterUtil.getLong((Object)accountAddress.getId());
                if (accountAddressId > 0L) {
                    CommerceAddress exisitingCommerceAddress = this._commerceAddressService.getCommerceAddress(accountAddressId);
                    this._commerceAddressService.updateCommerceAddress(exisitingCommerceAddress.getCommerceAddressId(), accountAddress.getName(), accountAddress.getDescription(), accountAddress.getStreet1(), accountAddress.getStreet2(), accountAddress.getStreet3(), accountAddress.getCity(), accountAddress.getZip(), this._getRegionId(country, accountAddress), country.getCountryId(), accountAddress.getPhoneNumber(), GetterUtil.getInteger((Object)accountAddress.getType(), (int)2), serviceContext);
                    if (GetterUtil.get((Object)accountAddress.getDefaultBilling(), (boolean)false)) {
                        this._accountEntryLocalService.updateDefaultBillingAddressId(accountEntry.getAccountEntryId(), exisitingCommerceAddress.getCommerceAddressId());
                    }
                    if (!GetterUtil.get((Object)accountAddress.getDefaultShipping(), (boolean)false)) continue;
                    this._accountEntryLocalService.updateDefaultShippingAddressId(accountEntry.getAccountEntryId(), exisitingCommerceAddress.getCommerceAddressId());
                    continue;
                }
                CommerceAddress commerceAddress = this._commerceAddressService.addCommerceAddress(GetterUtil.getString((String)accountAddress.getExternalReferenceCode(), null), AccountEntry.class.getName(), accountEntry.getAccountEntryId(), accountAddress.getName(), accountAddress.getDescription(), accountAddress.getStreet1(), accountAddress.getStreet2(), accountAddress.getStreet3(), accountAddress.getCity(), accountAddress.getZip(), this._getRegionId(country, accountAddress), country.getCountryId(), accountAddress.getPhoneNumber(), GetterUtil.getInteger((Object)accountAddress.getType(), (int)2), serviceContext);
                if (GetterUtil.get((Object)accountAddress.getDefaultBilling(), (boolean)false)) {
                    this._accountEntryLocalService.updateDefaultBillingAddressId(accountEntry.getAccountEntryId(), commerceAddress.getCommerceAddressId());
                }
                if (!GetterUtil.get((Object)accountAddress.getDefaultShipping(), (boolean)false)) continue;
                this._accountEntryLocalService.updateDefaultShippingAddressId(accountEntry.getAccountEntryId(), commerceAddress.getCommerceAddressId());
            }
        }
        if ((accountMembers = account.getAccountMembers()) != null) {
            for (AccountMember accountMember : accountMembers) {
                User user = AccountMemberUtil.getUser(this._userLocalService, accountMember, this.contextCompany.getCompanyId());
                AccountEntryUserRel accountEntryUserRel = this._accountEntryUserRelService.fetchAccountEntryUserRel(accountEntry.getAccountEntryId(), user.getUserId());
                if (accountEntryUserRel != null) continue;
                AccountMemberUtil.addAccountEntryUserRel(this._accountEntryModelResourcePermission, this._accountEntryUserRelService, accountMember, accountEntry, this._commerceAccountHelper, user, serviceContext);
            }
        }
        if ((accountOrganizations = account.getAccountOrganizations()) != null) {
            for (AccountOrganization accountOrganization : accountOrganizations) {
                long organizationId = AccountOrganizationUtil.getOrganizationId(this._organizationLocalService, accountOrganization, this.contextCompany.getCompanyId());
                AccountEntryOrganizationRel accountEntryOrganizationRel = this._accountEntryOrganizationRelService.fetchAccountEntryOrganizationRel(accountEntry.getAccountEntryId(), organizationId);
                if (accountEntryOrganizationRel != null) continue;
                this._accountEntryOrganizationRelService.addAccountEntryOrganizationRel(accountEntry.getAccountEntryId(), organizationId);
            }
        }
        return accountEntry;
    }
}

