/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	property = "dto.class.name=com.liferay.portal.kernel.model.UserGroupRole",
	service = DTOConverter.class
)
public class AccountRoleDTOConverter
	implements DTOConverter<UserGroupRole, AccountRole> {

	@Override
	public String getContentType() {
		return AccountRole.class.getSimpleName();
	}

	@Override
	public AccountRole toDTO(DTOConverterContext dtoConverterContext)
		throws Exception {

		UserGroupRole userGroupRole =
			_userGroupRoleLocalService.getUserGroupRole(
				(long)dtoConverterContext.getId());

		Role role = userGroupRole.getRole();

		return new AccountRole() {
			{
				description = LanguageUtils.getLanguageIdMap(
					role.getDescriptionMap());
				name = role.getName();
				roleId = role.getRoleId();
				title = LanguageUtils.getLanguageIdMap(role.getTitleMap());
			}
		};
	}

	@Reference
	private UserGroupRoleLocalService _userGroupRoleLocalService;

}