/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseUserResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.UserResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user.properties"}, scope=ServiceScope.PROTOTYPE, service={UserResource.class})
public class UserResourceImpl
extends BaseUserResourceImpl {
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.UserDTOConverter)")
    private DTOConverter<User, com.liferay.headless.commerce.admin.account.dto.v1_0.User> _userDTOConverter;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserService _userService;

    @Override
    public com.liferay.headless.commerce.admin.account.dto.v1_0.User postAccountByExternalReferenceCodeAccountMemberCreateUser(String externalReferenceCode, com.liferay.headless.commerce.admin.account.dto.v1_0.User user) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(accountEntry.getAccountEntryGroupId());
        User invitedUser = null;
        if (user.getId() != null) {
            invitedUser = this._userLocalService.fetchUserById(user.getId().longValue());
        } else if (Validator.isNotNull((String)user.getExternalReferenceCode())) {
            invitedUser = this._userLocalService.fetchUserByExternalReferenceCode(user.getExternalReferenceCode(), this.contextCompany.getCompanyId());
        }
        if (invitedUser == null) {
            invitedUser = this._userService.addUser(this.contextCompany.getCompanyId(), true, null, null, true, null, user.getEmail(), 0L, null, LocaleUtil.getDefault(), user.getFirstName(), user.getMiddleName(), user.getLastName(), 0L, 0L, GetterUtil.getBoolean((Object)user.getMale(), (boolean)true), 1, 1, 1970, user.getJobTitle(), new long[]{accountEntry.getAccountEntryGroupId()}, null, null, null, false, serviceContext);
        } else {
            Date birthday = invitedUser.getBirthday();
            Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar((long)birthday.getTime(), (TimeZone)invitedUser.getTimeZone());
            invitedUser = this._userService.updateUser(invitedUser.getUserId(), null, null, null, false, invitedUser.getReminderQueryQuestion(), invitedUser.getReminderQueryAnswer(), invitedUser.getScreenName(), GetterUtil.get((String)user.getEmail(), (String)invitedUser.getEmailAddress()), invitedUser.getFacebookId(), invitedUser.getOpenId(), invitedUser.getLanguageId(), invitedUser.getTimeZoneId(), invitedUser.getGreeting(), invitedUser.getComments(), user.getFirstName(), GetterUtil.get((String)user.getMiddleName(), (String)invitedUser.getMiddleName()), user.getLastName(), 0L, 0L, GetterUtil.get((Object)user.getMale(), (boolean)invitedUser.isMale()), birthdayCalendar.get(2), birthdayCalendar.get(5), birthdayCalendar.get(1), null, null, null, null, null, GetterUtil.get((String)user.getJobTitle(), (String)invitedUser.getJobTitle()), invitedUser.getGroupIds(), invitedUser.getOrganizationIds(), invitedUser.getRoleIds(), null, invitedUser.getUserGroupIds(), serviceContext);
        }
        if (Validator.isNotNull((String)user.getExternalReferenceCode())) {
            invitedUser.setExternalReferenceCode(user.getExternalReferenceCode());
            this._userLocalService.updateUser(invitedUser);
        }
        long[] roleIds = new long[]{};
        String[] roles = user.getRoles();
        if (roles != null) {
            for (String role : roles) {
                Role curRole = this._roleLocalService.getRole(this.contextCompany.getCompanyId(), role);
                roleIds = ArrayUtil.append((long[])roleIds, (long)curRole.getRoleId());
            }
        }
        this._commerceAccountHelper.addAccountEntryUserRel(accountEntry.getAccountEntryId(), invitedUser.getUserId(), roleIds, serviceContext);
        return (com.liferay.headless.commerce.admin.account.dto.v1_0.User)this._userDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)invitedUser.getUserId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

