/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.currency.exception.NoSuchCurrencyException;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyService;
import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.payment.exception.NoSuchPaymentMethodGroupRelException;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelService;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.product.exception.CommerceChannelAccountEntryRelTypeException;
import com.liferay.commerce.product.exception.NoSuchChannelException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.term.exception.NoSuchTermEntryException;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.CommerceTermEntryService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountChannelEntry;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountChannelEntryResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountChannelEntryResource;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-channel-entry.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountChannelEntryResource.class})
public class AccountChannelEntryResourceImpl
extends BaseAccountChannelEntryResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountChannelEntryDTOConverter)")
    private DTOConverter<CommerceChannelAccountEntryRel, AccountChannelEntry> _accountChannelEntryDTOConverter;
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.commerce.model.CommerceChannelAccountEntryRel)")
    private volatile ModelResourcePermission<CommerceChannelAccountEntryRel> _commerceChannelAccountEntryRelModelResourcePermission;
    @Reference
    private CommerceChannelAccountEntryRelService _commerceChannelAccountEntryRelService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceCurrencyService _commerceCurrencyService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CommercePaymentMethodGroupRelService _commercePaymentMethodGroupRelService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommerceTermEntryService _commerceTermEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private UserService _userService;

    @Override
    public void deleteAccountChannelBillingAddressId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 2);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public void deleteAccountChannelCurrencyId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 6);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public void deleteAccountChannelDeliveryTermId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 0);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public void deleteAccountChannelDiscountId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 5);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public void deleteAccountChannelPaymentMethodId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 8);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public void deleteAccountChannelPaymentTermId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 1);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public void deleteAccountChannelPriceListId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 4);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public void deleteAccountChannelShippingAddressId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 3);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public void deleteAccountChannelUserId(Long id) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, 7);
        this._commerceChannelAccountEntryRelService.deleteCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelBillingAddressesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 2, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelCurrenciesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 6, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelDeliveryTermsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 0, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelDiscountsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 5, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelPaymentMethodsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 8, HashMapBuilder.put((Object)"create", this._addExternalReferenceCodeAction("UPDATE", "postAccountByExternalReferenceCodeAccountChannelPaymentMethod", accountEntry)).put((Object)"get", this._addExternalReferenceCodeAction("VIEW", "getAccountByExternalReferenceCodeAccountChannelPaymentMethodsPage", accountEntry)).build(), pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelPaymentTermsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 1, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelPriceListsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 4, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelShippingAddressesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 3, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountByExternalReferenceCodeAccountChannelUsersPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), 7, pagination);
    }

    @Override
    public AccountChannelEntry getAccountChannelBillingAddressId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 2), 2);
    }

    @Override
    public AccountChannelEntry getAccountChannelCurrencyId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 6), 6);
    }

    @Override
    public AccountChannelEntry getAccountChannelDeliveryTermId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 0), 0);
    }

    @Override
    public AccountChannelEntry getAccountChannelDiscountId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 5), 5);
    }

    @Override
    public AccountChannelEntry getAccountChannelPaymentMethodId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 8), 8);
    }

    @Override
    public AccountChannelEntry getAccountChannelPaymentTermId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 1), 1);
    }

    @Override
    public AccountChannelEntry getAccountChannelPriceListId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 4), 4);
    }

    @Override
    public AccountChannelEntry getAccountChannelShippingAddressId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 3), 3);
    }

    @Override
    public AccountChannelEntry getAccountChannelUserId(Long id) throws Exception {
        return this._toAccountChannelEntry(this._getCommerceChannelAccountEntryRel(id, 7), 7);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelBillingAddressesPage(Long id, Pagination pagination) throws Exception {
        return this._getPage(id, 2, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelCurrenciesPage(Long id, Pagination pagination) throws Exception {
        return this._getPage(id, 6, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelDeliveryTermsPage(Long id, Pagination pagination) throws Exception {
        return this._getPage(id, 0, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelDiscountsPage(Long id, Pagination pagination) throws Exception {
        return this._getPage(id, 5, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelPaymentMethodsPage(Long id, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(GetterUtil.getLong((Object)id));
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(id, 8, HashMapBuilder.put((Object)"add", this.addAction("UPDATE", id, "postAccountIdAccountChannelPaymentMethod", this._accountEntryModelResourcePermission)).put((Object)"get", this.addAction("VIEW", id, "getAccountIdAccountChannelPaymentMethodsPage", this._accountEntryModelResourcePermission)).build(), pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelPaymentTermsPage(Long id, Pagination pagination) throws Exception {
        return this._getPage(id, 1, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelPriceListsPage(Long id, Pagination pagination) throws Exception {
        return this._getPage(id, 4, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelShippingAddressesPage(Long id, Pagination pagination) throws Exception {
        return this._getPage(id, 3, pagination);
    }

    @Override
    public Page<AccountChannelEntry> getAccountIdAccountChannelUsersPage(Long id, Pagination pagination) throws Exception {
        return this._getPage(id, 7, pagination);
    }

    @Override
    public AccountChannelEntry patchAccountChannelBillingAddressId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._patchAccountChannelEntry(accountChannelEntry, this._getCommerceChannelAccountEntryRel(id, 2), 2);
    }

    @Override
    public AccountChannelEntry patchAccountChannelCurrencyId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._patchAccountChannelEntry(accountChannelEntry, this._getCommerceChannelAccountEntryRel(id, 6), 6);
    }

    @Override
    public AccountChannelEntry patchAccountChannelDeliveryTermId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._patchAccountChannelEntry(accountChannelEntry, this._getCommerceChannelAccountEntryRel(id, 0), 0);
    }

    @Override
    public AccountChannelEntry patchAccountChannelDiscountId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._patchAccountChannelEntry(accountChannelEntry, this._getCommerceChannelAccountEntryRel(id, 5), 5);
    }

    @Override
    public AccountChannelEntry patchAccountChannelPaymentMethodId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._patchAccountChannelEntry(accountChannelEntry, this._getCommerceChannelAccountEntryRel(id, 8), 8);
    }

    @Override
    public AccountChannelEntry patchAccountChannelPaymentTermId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._patchAccountChannelEntry(accountChannelEntry, this._getCommerceChannelAccountEntryRel(id, 1), 1);
    }

    @Override
    public AccountChannelEntry patchAccountChannelPriceListId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._patchAccountChannelEntry(accountChannelEntry, this._getCommerceChannelAccountEntryRel(id, 4), 4);
    }

    @Override
    public AccountChannelEntry patchAccountChannelShippingAddressId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._patchAccountChannelEntry(accountChannelEntry, this._getCommerceChannelAccountEntryRel(id, 3), 3);
    }

    @Override
    public AccountChannelEntry patchAccountChannelUserId(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        int type = 7;
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._getCommerceChannelAccountEntryRel(id, type);
        long classPK = commerceChannelAccountEntryRel.getClassPK();
        if (accountChannelEntry.getClassPK() != null || accountChannelEntry.getClassExternalReferenceCode() != null) {
            classPK = this._getClassPK(accountChannelEntry, type);
        }
        this._checkPermission(this._userService.getUserById(classPK));
        return this._patchAccountChannelEntry(accountChannelEntry, commerceChannelAccountEntryRel, 7);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelBillingAddress(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), Address.class.getName(), 2);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelCurrency(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), CommerceCurrency.class.getName(), 6);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelDeliveryTerm(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), CommerceTermEntry.class.getName(), 0);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelDiscount(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), CommerceDiscount.class.getName(), 5);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelPaymentMethod(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), CommercePaymentMethodGroupRel.class.getName(), 8);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelPaymentTerm(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), CommerceTermEntry.class.getName(), 1);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelPriceList(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), CommercePriceList.class.getName(), 4);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelShippingAddress(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), Address.class.getName(), 3);
    }

    @Override
    public AccountChannelEntry postAccountByExternalReferenceCodeAccountChannelUser(String externalReferenceCode, AccountChannelEntry accountChannelEntry) throws Exception {
        this._checkPermission(this._userService.getUserById(this._getClassPK(accountChannelEntry, 7)));
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), User.class.getName(), 7);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelBillingAddress(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), Address.class.getName(), 2);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelCurrency(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), CommerceCurrency.class.getName(), 6);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelDeliveryTerm(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), CommerceTermEntry.class.getName(), 0);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelDiscount(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), CommerceDiscount.class.getName(), 5);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelPaymentMethod(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), CommercePaymentMethodGroupRel.class.getName(), 8);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelPaymentTerm(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), CommerceTermEntry.class.getName(), 1);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelPriceList(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), CommercePriceList.class.getName(), 4);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelShippingAddress(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), Address.class.getName(), 3);
    }

    @Override
    public AccountChannelEntry postAccountIdAccountChannelUser(Long id, AccountChannelEntry accountChannelEntry) throws Exception {
        this._checkPermission(this._userService.getUserById(this._getClassPK(accountChannelEntry, 7)));
        return this._postAccountChannelEntry(accountChannelEntry, this._accountEntryLocalService.fetchAccountEntry(id.longValue()), User.class.getName(), 7);
    }

    private Map<String, String> _addExternalReferenceCodeAction(String actionKey, String methodName, AccountEntry accountEntry) throws Exception {
        Map<String, String> action = this.addAction(actionKey, accountEntry.getAccountEntryId(), methodName, this._accountEntryModelResourcePermission);
        if (action == null) {
            return action;
        }
        action.put("href", StringUtil.replace((String)action.get("href"), (String)("by-externalReferenceCode/" + String.valueOf(accountEntry.getAccountEntryId())), (String)("by-externalReferenceCode/" + accountEntry.getExternalReferenceCode())));
        return action;
    }

    private void _checkPermission(User user) throws Exception {
        if (!this._accountEntryModelResourcePermission.contains(PermissionCheckerFactoryUtil.create((User)user), 0L, "MANAGE_AVAILABLE_ACCOUNTS_VIA_USER_CHANNEL_REL")) {
            throw new CommerceChannelAccountEntryRelTypeException("The user can not be set as account manager");
        }
    }

    private long _getClassPK(AccountChannelEntry accountChannelEntry, int type) throws Exception {
        if (type == 2) {
            int commerceAddressType;
            CommerceAddress commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(GetterUtil.getString((String)accountChannelEntry.getClassExternalReferenceCode()), this.contextCompany.getCompanyId());
            if (commerceAddress == null) {
                commerceAddress = this._commerceAddressService.getCommerceAddress(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
            }
            if (1 == (commerceAddressType = commerceAddress.getType()) || 2 == commerceAddressType) {
                return commerceAddress.getCommerceAddressId();
            }
        } else {
            if (type == 6) {
                CommerceCurrency commerceCurrency = this._commerceCurrencyService.getCommerceCurrency(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
                if (!commerceCurrency.isActive()) {
                    throw new NoSuchCurrencyException();
                }
                return commerceCurrency.getCommerceCurrencyId();
            }
            if (type == 0) {
                CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), GetterUtil.getString((String)accountChannelEntry.getClassExternalReferenceCode()));
                if (commerceTermEntry == null) {
                    commerceTermEntry = this._commerceTermEntryService.getCommerceTermEntry(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
                }
                if (!commerceTermEntry.isActive()) {
                    throw new NoSuchTermEntryException();
                }
                return commerceTermEntry.getCommerceTermEntryId();
            }
            if (type == 5) {
                CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(GetterUtil.getString((String)accountChannelEntry.getClassExternalReferenceCode()), this.contextCompany.getCompanyId());
                if (commerceDiscount == null) {
                    commerceDiscount = this._commerceDiscountService.getCommerceDiscount(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
                }
                if (!commerceDiscount.isActive()) {
                    throw new NoSuchDiscountException();
                }
                return commerceDiscount.getCommerceDiscountId();
            }
            if (type == 8) {
                CommerceChannel commerceChannel = this._commerceChannelService.fetchCommerceChannel(GetterUtil.getLong((Object)accountChannelEntry.getChannelId()));
                if (commerceChannel == null) {
                    throw new NoSuchChannelException();
                }
                CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelService.fetchCommercePaymentMethodGroupRel(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
                if (commercePaymentMethodGroupRel == null || !commercePaymentMethodGroupRel.isActive() ? (commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelService.fetchCommercePaymentMethodGroupRel(commerceChannel.getGroupId(), GetterUtil.getString((String)accountChannelEntry.getClassExternalReferenceCode()))) == null || !commercePaymentMethodGroupRel.isActive() : commercePaymentMethodGroupRel.getGroupId() != commerceChannel.getGroupId()) {
                    throw new NoSuchPaymentMethodGroupRelException();
                }
                return commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId();
            }
            if (type == 1) {
                CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), GetterUtil.getString((String)accountChannelEntry.getClassExternalReferenceCode()));
                if (commerceTermEntry == null) {
                    commerceTermEntry = this._commerceTermEntryService.getCommerceTermEntry(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
                }
                if (!commerceTermEntry.isActive()) {
                    throw new NoSuchTermEntryException();
                }
                return commerceTermEntry.getCommerceTermEntryId();
            }
            if (type == 4) {
                CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(GetterUtil.getString((String)accountChannelEntry.getClassExternalReferenceCode()), this.contextCompany.getCompanyId());
                if (commercePriceList == null) {
                    commercePriceList = this._commercePriceListService.getCommercePriceList(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
                }
                if (commercePriceList.isInactive()) {
                    throw new NoSuchPriceListException();
                }
                return commercePriceList.getCommercePriceListId();
            }
            if (type == 3) {
                int commerceAddressType;
                CommerceAddress commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(GetterUtil.getString((String)accountChannelEntry.getClassExternalReferenceCode()), this.contextCompany.getCompanyId());
                if (commerceAddress == null) {
                    commerceAddress = this._commerceAddressService.getCommerceAddress(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
                }
                if (3 == (commerceAddressType = commerceAddress.getType()) || 2 == commerceAddressType) {
                    return commerceAddress.getCommerceAddressId();
                }
            } else if (type == 7) {
                User user = this._userService.fetchUserByExternalReferenceCode(this.contextCompany.getCompanyId(), accountChannelEntry.getClassExternalReferenceCode());
                if (user == null) {
                    user = this._userService.getUserById(GetterUtil.getLong((Object)accountChannelEntry.getClassPK()));
                }
                if (!user.isActive()) {
                    throw new NoSuchUserException();
                }
                return user.getUserId();
            }
        }
        throw new CommerceChannelAccountEntryRelTypeException("Unknown type: " + type);
    }

    private CommerceChannelAccountEntryRel _getCommerceChannelAccountEntryRel(Long id, int type) throws Exception {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelService.getCommerceChannelAccountEntryRel(id.longValue());
        if (type != commerceChannelAccountEntryRel.getType()) {
            throw new CommerceChannelAccountEntryRelTypeException("Types do not match");
        }
        return commerceChannelAccountEntryRel;
    }

    private long _getCommerceChannelId(AccountChannelEntry accountChannelEntry, int type) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelService.fetchByExternalReferenceCode(GetterUtil.getString((String)accountChannelEntry.getChannelExternalReferenceCode()), this.contextCompany.getCompanyId());
        if (commerceChannel == null) {
            commerceChannel = this._commerceChannelService.fetchCommerceChannel(GetterUtil.getLong((Object)accountChannelEntry.getChannelId()));
        }
        if (commerceChannel == null) {
            if (type != 8) {
                return 0L;
            }
            throw new NoSuchChannelException();
        }
        return commerceChannel.getCommerceChannelId();
    }

    private Page<AccountChannelEntry> _getPage(long accountEntryId, int accountEntryType, Map<String, Map<String, String>> actions, Pagination pagination) throws Exception {
        return Page.of(actions, this.transform(this._commerceChannelAccountEntryRelService.getCommerceChannelAccountEntryRels(accountEntryId, accountEntryType, pagination.getStartPosition(), pagination.getEndPosition(), null), commerceChannelAccountEntryRel -> this._toAccountChannelEntry((CommerceChannelAccountEntryRel)commerceChannelAccountEntryRel, accountEntryType)), (Pagination)pagination, (long)this._commerceChannelAccountEntryRelService.getCommerceChannelAccountEntryRelsCount(accountEntryId, accountEntryType));
    }

    private Page<AccountChannelEntry> _getPage(long accountEntryId, int accountEntryType, Pagination pagination) throws Exception {
        return this._getPage(accountEntryId, accountEntryType, null, pagination);
    }

    private AccountChannelEntry _patchAccountChannelEntry(AccountChannelEntry accountChannelEntry, CommerceChannelAccountEntryRel commerceChannelAccountEntryRel, int type) throws Exception {
        long commerceChannelId = commerceChannelAccountEntryRel.getCommerceChannelId();
        if (accountChannelEntry.getChannelId() != null) {
            commerceChannelId = this._getCommerceChannelId(accountChannelEntry, commerceChannelAccountEntryRel.getType());
        }
        accountChannelEntry.setChannelId(Long.valueOf(commerceChannelId));
        long classPK = commerceChannelAccountEntryRel.getClassPK();
        if (accountChannelEntry.getClassPK() != null || accountChannelEntry.getClassExternalReferenceCode() != null) {
            classPK = this._getClassPK(accountChannelEntry, type);
        }
        return this._toAccountChannelEntry(this._commerceChannelAccountEntryRelService.updateCommerceChannelAccountEntryRel(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId(), commerceChannelId, classPK, GetterUtil.getBoolean((Object)accountChannelEntry.getOverrideEligibility(), (boolean)commerceChannelAccountEntryRel.isOverrideEligibility()), GetterUtil.getDouble((Object)accountChannelEntry.getPriority(), (double)commerceChannelAccountEntryRel.getPriority())), type);
    }

    private AccountChannelEntry _postAccountChannelEntry(AccountChannelEntry accountChannelEntry, AccountEntry accountEntry, String className, int type) throws Exception {
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._toAccountChannelEntry(this._commerceChannelAccountEntryRelService.addCommerceChannelAccountEntryRel(accountEntry.getAccountEntryId(), className, this._getClassPK(accountChannelEntry, type), this._getCommerceChannelId(accountChannelEntry, type), GetterUtil.getBoolean((Object)accountChannelEntry.getOverrideEligibility()), GetterUtil.getDouble((Object)accountChannelEntry.getPriority()), type), type);
    }

    private AccountChannelEntry _toAccountChannelEntry(CommerceChannelAccountEntryRel commerceChannelAccountEntryRel, int type) throws Exception {
        HashMap actions = null;
        if (type == 8) {
            actions = HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId(), "deleteAccountChannelPaymentMethodId", this._commerceChannelAccountEntryRelModelResourcePermission)).put((Object)"get", this.addAction("VIEW", commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId(), "getAccountChannelPaymentMethodId", this._commerceChannelAccountEntryRelModelResourcePermission)).put((Object)"patch", this.addAction("UPDATE", commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId(), "patchAccountChannelPaymentMethodId", this._commerceChannelAccountEntryRelModelResourcePermission)).build();
        }
        return (AccountChannelEntry)this._accountChannelEntryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), actions, this._dtoConverterRegistry, (Object)commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

