/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.util.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountUserRelService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;

public class AccountMemberUtil {
    public static CommerceAccountUserRel addCommerceAccountUserRel(CommerceAccountUserRelService commerceAccountUserRelService, AccountMember accountMember, AccountEntry accountEntry, User user, ServiceContext serviceContext) throws PortalException {
        long[] roleIds = null;
        AccountRole[] accountRoles = accountMember.getAccountRoles();
        if (accountRoles != null) {
            roleIds = TransformUtil.transformToLongArray(Arrays.asList(accountRoles), AccountRole::getRoleId);
        }
        return commerceAccountUserRelService.addCommerceAccountUserRel(accountEntry.getAccountEntryId(), user.getUserId(), roleIds, serviceContext);
    }

    public static User getUser(UserLocalService userLocalService, AccountMember accountMember, long companyId) throws PortalException {
        User user = null;
        if (Validator.isNotNull((String)accountMember.getEmail())) {
            user = userLocalService.getUserByEmailAddress(companyId, accountMember.getEmail());
        } else if (Validator.isNotNull((String)accountMember.getUserExternalReferenceCode())) {
            user = userLocalService.fetchUserByExternalReferenceCode(accountMember.getUserExternalReferenceCode(), companyId);
            if (user == null) {
                throw new NoSuchUserException("Unable to get user with external reference code " + accountMember.getUserExternalReferenceCode());
            }
        } else {
            user = userLocalService.getUser(accountMember.getUserId().longValue());
        }
        return user;
    }
}

