/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountGroup;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	property = "dto.class.name=com.liferay.commerce.account.model.CommerceAccountGroup",
	service = DTOConverter.class
)
public class AccountGroupDTOConverter
	implements DTOConverter<CommerceAccountGroup, AccountGroup> {

	@Override
	public String getContentType() {
		return AccountGroup.class.getSimpleName();
	}

	@Override
	public AccountGroup toDTO(DTOConverterContext dtoConverterContext)
		throws Exception {

		CommerceAccountGroup commerceAccountGroup =
			_commerceAccountGroupService.getCommerceAccountGroup(
				(Long)dtoConverterContext.getId());

		ExpandoBridge expandoBridge = commerceAccountGroup.getExpandoBridge();

		return new AccountGroup() {
			{
				customFields = expandoBridge.getAttributes();
				externalReferenceCode =
					commerceAccountGroup.getExternalReferenceCode();
				id = commerceAccountGroup.getCommerceAccountGroupId();
				name = commerceAccountGroup.getName();
			}
		};
	}

	@Reference
	private CommerceAccountGroupService _commerceAccountGroupService;

}