/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountUserRelService;
import com.liferay.commerce.account.service.persistence.CommerceAccountUserRelPK;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.account.model.CommerceAccountUserRel"}, service={DTOConverter.class})
public class AccountMemberDTOConverter
implements DTOConverter<CommerceAccountUserRel, AccountMember> {
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountRoleDTOConverter)")
    private DTOConverter<UserGroupRole, AccountRole> _accountRoleDTOConverter;
    @Reference
    private CommerceAccountUserRelService _commerceAccountUserRelService;

    public String getContentType() {
        return AccountMember.class.getSimpleName();
    }

    public AccountMember toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAccountUserRel commerceAccountUserRel = this._commerceAccountUserRelService.getCommerceAccountUserRel((CommerceAccountUserRelPK)dtoConverterContext.getId());
        final User user = commerceAccountUserRel.getUser();
        return new AccountMember(){
            {
                this.accountId = commerceAccountUserRel.getCommerceAccountId();
                this.accountRoles = AccountMemberDTOConverter.this._getAccountRoles(commerceAccountUserRel, dtoConverterContext);
                this.email = user.getEmailAddress();
                this.name = user.getFullName();
                this.userId = user.getUserId();
            }
        };
    }

    private AccountRole[] _getAccountRoles(CommerceAccountUserRel commerceAccountUserRel, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<Object> accountRoles = new ArrayList<Object>();
        for (UserGroupRole userGroupRole : commerceAccountUserRel.getUserGroupRoles()) {
            accountRoles.add(this._accountRoleDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)userGroupRole.getPrimaryKey(), dtoConverterContext.getLocale())));
        }
        Stream stream = accountRoles.stream();
        return (AccountRole[])stream.toArray(AccountRole[]::new);
    }
}

