/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryService;
import com.liferay.commerce.account.exception.NoSuchAccountGroupException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.model.CommerceAccountGroupCommerceAccountRel;
import com.liferay.commerce.account.model.CommerceAccountOrganizationRel;
import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountGroupCommerceAccountRelService;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.account.service.CommerceAccountOrganizationRelService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.account.service.CommerceAccountUserRelService;
import com.liferay.commerce.account.service.persistence.CommerceAccountOrganizationRelPK;
import com.liferay.commerce.account.service.persistence.CommerceAccountUserRelPK;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountDTOConverter;
import com.liferay.headless.commerce.admin.account.internal.odata.entity.v1_0.AccountEntityModel;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountResourceImpl;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountMemberUtil;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountOrganizationUtil;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountResource;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountResource.class})
public class AccountResourceImpl
extends BaseAccountResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountResourceImpl.class);
    private static final EntityModel _entityModel = new AccountEntityModel();
    @Reference
    private AccountDTOConverter _accountDTOConverter;
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private CommerceAccountGroupCommerceAccountRelService _commerceAccountGroupCommerceAccountRelService;
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private CommerceAccountOrganizationRelService _commerceAccountOrganizationRelService;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAccountUserRelService _commerceAccountUserRelService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CountryService _countryService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RegionLocalService _regionLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Response deleteAccount(Long id) throws Exception {
        this._commerceAccountService.deleteCommerceAccount(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this._commerceAccountService.deleteCommerceAccount(commerceAccount.getCommerceAccountId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountGroupByExternalReferenceCodeAccount(String accountExternalReferenceCode, String externalReferenceCode) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccountGroup == null) {
            throw new NoSuchAccountGroupException("Unable to find account group with external reference code " + externalReferenceCode);
        }
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), accountExternalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find Account with external reference code: " + accountExternalReferenceCode);
        }
        CommerceAccountGroupCommerceAccountRel commerceAccountGroupCommerceAccountRel = this._commerceAccountGroupCommerceAccountRelService.getCommerceAccountGroupCommerceAccountRel(commerceAccountGroup.getCommerceAccountGroupId(), commerceAccount.getCommerceAccountId());
        this._commerceAccountGroupCommerceAccountRelService.deleteCommerceAccountGroupCommerceAccountRel(commerceAccountGroupCommerceAccountRel.getCommerceAccountGroupCommerceAccountRelId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Account getAccount(Long id) throws Exception {
        return this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)GetterUtil.getLong((Object)id), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Account getAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        return this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccount.getCommerceAccountId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<Account> getAccountsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)AccountEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toAccount(this._accountEntryService.getAccountEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Response patchAccount(Long id, Account account) throws Exception {
        this._updateAccount(id, account);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountByExternalReferenceCode(String externalReferenceCode, Account account) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this._updateAccount(commerceAccount.getCommerceAccountId(), account);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Account postAccount(Account account) throws Exception {
        Map customFields;
        CommerceAccount commerceAccount = this._commerceAccountService.addOrUpdateCommerceAccount(account.getName(), 0L, true, null, this._getEmailAddress(account, null), account.getTaxId(), GetterUtil.get((Object)account.getType(), (int)1), GetterUtil.getBoolean((Object)account.getActive(), (boolean)true), account.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext());
        if (this._isValidId(account.getDefaultBillingAccountAddressId())) {
            this._commerceAccountService.updateDefaultBillingAddress(commerceAccount.getCommerceAccountId(), account.getDefaultBillingAccountAddressId().longValue());
        }
        if (this._isValidId(account.getDefaultShippingAccountAddressId())) {
            this._commerceAccountService.updateDefaultShippingAddress(commerceAccount.getCommerceAccountId(), account.getDefaultShippingAccountAddressId().longValue());
        }
        if ((customFields = account.getCustomFields()) != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), AccountEntry.class, (long)commerceAccount.getPrimaryKey(), (Map)customFields);
        }
        this._updateNestedResources(account, commerceAccount, this._serviceContextHelper.getServiceContext());
        return this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccount.getCommerceAccountId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Response postAccountByExternalReferenceCodeLogo(String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this.updateAccountLogo(commerceAccount, multipartBody);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response postAccountGroupByExternalReferenceCodeAccount(String externalReferenceCode, Account account) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccountGroup == null) {
            throw new NoSuchAccountGroupException("Unable to find account group with external reference code " + externalReferenceCode);
        }
        CommerceAccount commerceAccount = null;
        if (account.getId() != null) {
            commerceAccount = this._commerceAccountService.fetchCommerceAccount(account.getId().longValue());
        } else if (account.getExternalReferenceCode() != null) {
            commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), account.getExternalReferenceCode());
        }
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find Account with external reference code: " + account.getExternalReferenceCode());
        }
        this._commerceAccountGroupCommerceAccountRelService.addCommerceAccountGroupCommerceAccountRel(commerceAccountGroup.getCommerceAccountGroupId(), commerceAccount.getCommerceAccountId(), this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response postAccountLogo(Long id, MultipartBody multipartBody) throws Exception {
        this.updateAccountLogo(this._commerceAccountService.getCommerceAccount(id.longValue()), multipartBody);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    public void updateAccountLogo(CommerceAccount commerceAccount, MultipartBody multipartBody) throws IOException, PortalException {
        this._commerceAccountService.updateCommerceAccount(commerceAccount.getCommerceAccountId(), commerceAccount.getName(), true, multipartBody.getBinaryFileAsBytes("logo"), commerceAccount.getEmail(), commerceAccount.getTaxId(), commerceAccount.isActive(), this._serviceContextHelper.getServiceContext(commerceAccount.getCommerceAccountGroupId()));
    }

    private String _getEmailAddress(Account account, CommerceAccount commerceAccount) {
        String[] emailAddresses = new String[]{};
        if (account.getEmailAddresses() != null) {
            emailAddresses = account.getEmailAddresses();
        }
        if (emailAddresses.length > 0) {
            return emailAddresses[0];
        }
        if (commerceAccount == null) {
            return "";
        }
        return commerceAccount.getEmail();
    }

    private long _getRegionId(Country country, AccountAddress accountAddress) throws Exception {
        if (Validator.isNull((String)accountAddress.getRegionISOCode()) || country == null) {
            return 0L;
        }
        Region region = this._regionLocalService.fetchRegion(country.getCountryId(), accountAddress.getRegionISOCode());
        if (region == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to find region with ISO code ", accountAddress.getRegionISOCode(), " for country ", country.getCountryId()}));
            }
            return 0L;
        }
        return region.getRegionId();
    }

    private boolean _isValidId(Long value) {
        return value != null && value > 0L;
    }

    private Account _toAccount(AccountEntry accountEntry) throws Exception {
        if (accountEntry == null) {
            return null;
        }
        return this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntry.getAccountEntryId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private Account _toAccount(CommerceAccount commerceAccount) throws Exception {
        if (commerceAccount == null) {
            return null;
        }
        return this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccount.getCommerceAccountId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private CommerceAccount _updateAccount(Long id, Account account) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.getCommerceAccount(id.longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceAccount.getCommerceAccountGroupId());
        commerceAccount = this._commerceAccountService.updateCommerceAccount(commerceAccount.getCommerceAccountId(), account.getName(), true, null, this._getEmailAddress(account, commerceAccount), GetterUtil.get((String)account.getTaxId(), (String)commerceAccount.getTaxId()), GetterUtil.getBoolean((Object)account.getActive(), (boolean)commerceAccount.isActive()), GetterUtil.getLong((Object)account.getDefaultBillingAccountAddressId(), (long)commerceAccount.getDefaultBillingAddressId()), GetterUtil.getLong((Object)account.getDefaultShippingAccountAddressId(), (long)commerceAccount.getDefaultShippingAddressId()), account.getExternalReferenceCode(), serviceContext);
        Map customFields = account.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), AccountEntry.class, (long)commerceAccount.getPrimaryKey(), (Map)customFields);
        }
        this._updateNestedResources(account, commerceAccount, serviceContext);
        return commerceAccount;
    }

    private CommerceAccount _updateNestedResources(Account account, CommerceAccount commerceAccount, ServiceContext serviceContext) throws Exception {
        AccountOrganization[] accountOrganizations;
        AccountMember[] accountMembers;
        AccountAddress[] accountAddresses = account.getAccountAddresses();
        if (accountAddresses != null) {
            for (AccountAddress accountAddress : accountAddresses) {
                Country country = this._countryService.fetchCountryByA2(commerceAccount.getCompanyId(), accountAddress.getCountryISOCode());
                if (country == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to import account address with ", "country ISO code ", account.getName(), " and account name ", accountAddress.getCountryISOCode()}));
                    continue;
                }
                long accountAddressId = GetterUtil.getLong((Object)accountAddress.getId());
                if (accountAddressId > 0L) {
                    CommerceAddress exisitingCommerceAddress = this._commerceAddressService.getCommerceAddress(accountAddressId);
                    this._commerceAddressService.updateCommerceAddress(exisitingCommerceAddress.getCommerceAddressId(), accountAddress.getName(), accountAddress.getDescription(), accountAddress.getStreet1(), accountAddress.getStreet2(), accountAddress.getStreet3(), accountAddress.getCity(), accountAddress.getZip(), this._getRegionId(country, accountAddress), country.getCountryId(), accountAddress.getPhoneNumber(), GetterUtil.getInteger((Object)accountAddress.getType(), (int)2), serviceContext);
                    if (GetterUtil.get((Object)accountAddress.getDefaultBilling(), (boolean)false)) {
                        this._commerceAccountService.updateDefaultBillingAddress(commerceAccount.getCommerceAccountId(), exisitingCommerceAddress.getCommerceAddressId());
                    }
                    if (!GetterUtil.get((Object)accountAddress.getDefaultShipping(), (boolean)false)) continue;
                    this._commerceAccountService.updateDefaultShippingAddress(commerceAccount.getCommerceAccountId(), exisitingCommerceAddress.getCommerceAddressId());
                    continue;
                }
                CommerceAddress commerceAddress = this._commerceAddressService.addCommerceAddress(GetterUtil.getString((String)accountAddress.getExternalReferenceCode(), null), AccountEntry.class.getName(), commerceAccount.getCommerceAccountId(), accountAddress.getName(), accountAddress.getDescription(), accountAddress.getStreet1(), accountAddress.getStreet2(), accountAddress.getStreet3(), accountAddress.getCity(), accountAddress.getZip(), this._getRegionId(country, accountAddress), country.getCountryId(), accountAddress.getPhoneNumber(), GetterUtil.getInteger((Object)accountAddress.getType(), (int)2), serviceContext);
                if (GetterUtil.get((Object)accountAddress.getDefaultBilling(), (boolean)false)) {
                    this._commerceAccountService.updateDefaultBillingAddress(commerceAccount.getCommerceAccountId(), commerceAddress.getCommerceAddressId());
                }
                if (!GetterUtil.get((Object)accountAddress.getDefaultShipping(), (boolean)false)) continue;
                this._commerceAccountService.updateDefaultShippingAddress(commerceAccount.getCommerceAccountId(), commerceAddress.getCommerceAddressId());
            }
        }
        if ((accountMembers = account.getAccountMembers()) != null) {
            for (AccountMember accountMember : accountMembers) {
                User user = AccountMemberUtil.getUser(this._userLocalService, accountMember, this.contextCompany.getCompanyId());
                CommerceAccountUserRel commerceAccountUserRel = this._commerceAccountUserRelService.fetchCommerceAccountUserRel(new CommerceAccountUserRelPK(commerceAccount.getCommerceAccountId(), user.getUserId()));
                if (commerceAccountUserRel != null) continue;
                AccountMemberUtil.addCommerceAccountUserRel(this._commerceAccountUserRelService, accountMember, commerceAccount, user, serviceContext);
            }
        }
        if ((accountOrganizations = account.getAccountOrganizations()) != null) {
            for (AccountOrganization accountOrganization : accountOrganizations) {
                long organizationId = AccountOrganizationUtil.getOrganizationId(this._organizationLocalService, accountOrganization, this.contextCompany.getCompanyId());
                CommerceAccountOrganizationRel commerceAccountOrganizationRel = this._commerceAccountOrganizationRelService.fetchCommerceAccountOrganizationRel(new CommerceAccountOrganizationRelPK(commerceAccount.getCommerceAccountId(), organizationId));
                if (commerceAccountOrganizationRel != null) continue;
                this._commerceAccountOrganizationRelService.addCommerceAccountOrganizationRel(commerceAccount.getCommerceAccountId(), organizationId, serviceContext);
            }
        }
        return commerceAccount;
    }
}

