/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.account.service.CommerceAccountUserRelService;
import com.liferay.commerce.account.service.persistence.CommerceAccountUserRelPK;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountMemberDTOConverter;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountMemberResourceImpl;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountMemberUtil;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountMemberResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-member.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountMemberResource.class, NestedFieldSupport.class})
public class AccountMemberResourceImpl
extends BaseAccountMemberResourceImpl
implements NestedFieldSupport {
    @Reference
    private AccountMemberDTOConverter _accountMemberDTOConverter;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAccountUserRelService _commerceAccountUserRelService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Response deleteAccountByExternalReferenceCodeAccountMember(String externalReferenceCode, Long userId) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this._commerceAccountUserRelService.deleteCommerceAccountUserRel(commerceAccount.getCommerceAccountId(), userId.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountIdAccountMember(Long id, Long userId) throws Exception {
        this._commerceAccountUserRelService.deleteCommerceAccountUserRel(id.longValue(), userId.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public AccountMember getAccountByExternalReferenceCodeAccountMember(String externalReferenceCode, Long userId) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        CommerceAccountUserRel commerceAccountUserRel = this._commerceAccountUserRelService.getCommerceAccountUserRel(new CommerceAccountUserRelPK(commerceAccount.getCommerceAccountId(), userId.longValue()));
        return this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<AccountMember> getAccountByExternalReferenceCodeAccountMembersPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        List commerceAccountUserRels = this._commerceAccountUserRelService.getCommerceAccountUserRels(commerceAccount.getCommerceAccountId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceAccountUserRelService.getCommerceAccountUserRelsCount(commerceAccount.getCommerceAccountId());
        return Page.of(this._toAccountMembers(commerceAccountUserRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public AccountMember getAccountIdAccountMember(Long id, Long userId) throws Exception {
        return this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)new CommerceAccountUserRelPK(id.longValue(), userId.longValue()), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Account.class, value="accountMembers")
    public Page<AccountMember> getAccountIdAccountMembersPage(Long id, Pagination pagination) throws Exception {
        List commerceAccountUserRels = this._commerceAccountUserRelService.getCommerceAccountUserRels(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceAccountUserRelService.getCommerceAccountUserRelsCount(id.longValue());
        return Page.of(this._toAccountMembers(commerceAccountUserRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Response patchAccountByExternalReferenceCodeAccountMember(String externalReferenceCode, Long userId, AccountMember accountMember) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this._updateCommerceAccountUserRel(commerceAccount, this._userLocalService.getUser(userId.longValue()), accountMember);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountIdAccountMember(Long id, Long userId, AccountMember accountMember) throws Exception {
        this._updateCommerceAccountUserRel(this._commerceAccountService.getCommerceAccount(id.longValue()), this._userLocalService.getUser(userId.longValue()), accountMember);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AccountMember postAccountByExternalReferenceCodeAccountMember(String externalReferenceCode, AccountMember accountMember) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        CommerceAccountUserRel commerceAccountUserRel = AccountMemberUtil.addCommerceAccountUserRel(this._commerceAccountUserRelService, accountMember, commerceAccount, AccountMemberUtil.getUser(this._userLocalService, accountMember, this.contextCompany.getCompanyId()), this._serviceContextHelper.getServiceContext());
        return this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public AccountMember postAccountIdAccountMember(Long id, AccountMember accountMember) throws Exception {
        CommerceAccountUserRel commerceAccountUserRel = AccountMemberUtil.addCommerceAccountUserRel(this._commerceAccountUserRelService, accountMember, this._commerceAccountService.getCommerceAccount(id.longValue()), AccountMemberUtil.getUser(this._userLocalService, accountMember, this.contextCompany.getCompanyId()), this._serviceContextHelper.getServiceContext());
        return this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<AccountMember> _toAccountMembers(List<CommerceAccountUserRel> commerceAccountUserRels) throws Exception {
        ArrayList<AccountMember> accountMembers = new ArrayList<AccountMember>();
        for (CommerceAccountUserRel commerceAccountUserRel : commerceAccountUserRels) {
            accountMembers.add(this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return accountMembers;
    }

    private void _updateCommerceAccountUserRel(CommerceAccount commerceAccount, User user, AccountMember accountMember) throws Exception {
        this._userGroupRoleLocalService.deleteUserGroupRoles(user.getUserId(), new long[]{commerceAccount.getCommerceAccountGroupId()});
        AccountRole[] accountRoles = accountMember.getAccountRoles();
        if (accountRoles != null) {
            Stream<AccountRole> accountRoleStream = Arrays.stream(accountRoles);
            long[] roleIds = accountRoleStream.mapToLong(AccountRole::getRoleId).toArray();
            this._userGroupRoleLocalService.addUserGroupRoles(user.getUserId(), commerceAccount.getCommerceAccountGroupId(), roleIds);
        }
    }
}

