/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.service.CommerceShippingOptionAccountEntryRelService;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountChannelShippingOption;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel"}, service={AccountChannelShippingOptionDTOConverter.class, DTOConverter.class})
public class AccountChannelShippingOptionDTOConverter
implements DTOConverter<CommerceShippingOptionAccountEntryRel, AccountChannelShippingOption> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceShippingFixedOptionLocalService _commerceShippingFixedOptionLocalService;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private CommerceShippingOptionAccountEntryRelService _commerceShippingOptionAccountEntryRelService;

    public String getContentType() {
        return AccountChannelShippingOption.class.getSimpleName();
    }

    public AccountChannelShippingOption toDTO(final DTOConverterContext dtoConverterContext, final CommerceShippingOptionAccountEntryRel commerceShippingOptionAccountEntryRel) throws Exception {
        return new AccountChannelShippingOption(){
            {
                this.accountId = commerceShippingOptionAccountEntryRel.getAccountEntryId();
                this.actions = dtoConverterContext.getActions();
                this.channelId = commerceShippingOptionAccountEntryRel.getCommerceChannelId();
                this.id = commerceShippingOptionAccountEntryRel.getCommerceShippingOptionAccountEntryRelId();
                this.shippingMethodKey = commerceShippingOptionAccountEntryRel.getCommerceShippingMethodKey();
                this.shippingOptionKey = commerceShippingOptionAccountEntryRel.getCommerceShippingOptionKey();
                this.setAccountExternalReferenceCode(() -> {
                    AccountEntry accountEntry = AccountChannelShippingOptionDTOConverter.this._accountEntryLocalService.fetchAccountEntry(commerceShippingOptionAccountEntryRel.getAccountEntryId());
                    if (accountEntry != null && !Validator.isBlank((String)accountEntry.getExternalReferenceCode())) {
                        return accountEntry.getExternalReferenceCode();
                    }
                    return null;
                });
                this.setShippingMethodId(() -> {
                    CommerceChannel commerceChannel = AccountChannelShippingOptionDTOConverter.this._commerceChannelLocalService.getCommerceChannel(commerceShippingOptionAccountEntryRel.getCommerceChannelId());
                    CommerceShippingMethod commerceShippingMethod = AccountChannelShippingOptionDTOConverter.this._commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceChannel.getGroupId(), commerceShippingOptionAccountEntryRel.getCommerceShippingMethodKey());
                    if (commerceShippingMethod == null) {
                        return 0L;
                    }
                    return commerceShippingMethod.getCommerceShippingMethodId();
                });
                this.setShippingOptionId(() -> {
                    CommerceShippingFixedOption commerceShippingFixedOption = AccountChannelShippingOptionDTOConverter.this._commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(commerceShippingOptionAccountEntryRel.getCompanyId(), commerceShippingOptionAccountEntryRel.getCommerceShippingOptionKey());
                    if (commerceShippingFixedOption == null) {
                        return 0L;
                    }
                    return commerceShippingFixedOption.getCommerceShippingFixedOptionId();
                });
            }
        };
    }
}

