/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.account.internal.util.v1_0;

import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.Validator;

/**
 * @author Alessio Antonio Rendina
 */
public class AccountOrganizationUtil {

	public static long getOrganizationId(
			OrganizationLocalService organizationLocalService,
			AccountOrganization accountOrganization, long companyId)
		throws PortalException {

		Organization organization;

		if (Validator.isNotNull(
				accountOrganization.getOrganizationExternalReferenceCode())) {

			organization =
				organizationLocalService.fetchOrganizationByReferenceCode(
					companyId,
					accountOrganization.getOrganizationExternalReferenceCode());

			if (organization == null) {
				String organizationExternalReferenceCode =
					accountOrganization.getOrganizationExternalReferenceCode();

				throw new NoSuchOrganizationException(
					"Unable to find organization with external reference " +
						"code " + organizationExternalReferenceCode);
			}
		}
		else {
			organization = organizationLocalService.getOrganization(
				accountOrganization.getOrganizationId());
		}

		return organization.getOrganizationId();
	}

}