/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"dto.class.name=com.liferay.commerce.account.model.CommerceAccount"}, service={AccountDTOConverter.class, DTOConverter.class})
public class AccountDTOConverter
implements DTOConverter<CommerceAccount, Account> {
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public Account toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        CommerceAccount commerceAccount;
        if ((Long)dtoConverterContext.getId() == -1L) {
            User user = dtoConverterContext.getUser();
            if (user == null) {
                user = this._userLocalService.getUserById(PrincipalThreadLocal.getUserId());
            }
            commerceAccount = this._commerceAccountLocalService.getGuestCommerceAccount(user.getCompanyId());
        } else {
            commerceAccount = this._commerceAccountService.getCommerceAccount(((Long)dtoConverterContext.getId()).longValue());
        }
        final ExpandoBridge expandoBridge = commerceAccount.getExpandoBridge();
        return new Account(){
            {
                this.active = commerceAccount.isActive();
                this.customFields = expandoBridge.getAttributes();
                this.dateCreated = commerceAccount.getCreateDate();
                this.dateModified = commerceAccount.getModifiedDate();
                this.defaultBillingAccountAddressId = commerceAccount.getDefaultBillingAddressId();
                this.defaultShippingAccountAddressId = commerceAccount.getDefaultShippingAddressId();
                this.emailAddresses = new String[]{commerceAccount.getEmail()};
                this.externalReferenceCode = commerceAccount.getExternalReferenceCode();
                this.id = commerceAccount.getCommerceAccountId();
                this.logoId = commerceAccount.getLogoId();
                this.logoURL = AccountDTOConverter.this._getLogoURL(commerceAccount.getLogoId());
                this.name = commerceAccount.getName();
                this.root = commerceAccount.isRoot();
                this.taxId = commerceAccount.getTaxId();
                this.type = commerceAccount.getType();
            }
        };
    }

    private String _getLogoURL(long logoId) {
        return StringBundler.concat((Object[])new Object[]{"/image/organization_logo?img_id=", logoId, "&t=", WebServerServletTokenUtil.getToken((long)logoId)});
    }
}

