/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryUserRelService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.account.model.AccountEntryUserRel"}, service={DTOConverter.class})
public class AccountMemberDTOConverter
implements DTOConverter<AccountEntryUserRel, AccountMember> {
    @Reference
    private AccountEntryUserRelService _accountEntryUserRelService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountRoleDTOConverter)")
    private DTOConverter<UserGroupRole, AccountRole> _accountRoleDTOConverter;

    public String getContentType() {
        return AccountMember.class.getSimpleName();
    }

    public AccountMember toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final AccountEntryUserRel accountEntryUserRel = this._accountEntryUserRelService.fetchAccountEntryUserRel(((Long)dtoConverterContext.getId()).longValue());
        final User user = accountEntryUserRel.getUser();
        return new AccountMember(){
            {
                this.setAccountId(() -> ((AccountEntryUserRel)accountEntryUserRel).getAccountEntryId());
                this.setAccountRoles(() -> AccountMemberDTOConverter.this._getAccountRoles(accountEntryUserRel, dtoConverterContext));
                this.setEmail(() -> ((User)user).getEmailAddress());
                this.setName(() -> ((User)user).getFullName());
                this.setUserId(() -> ((User)user).getUserId());
            }
        };
    }

    private AccountRole[] _getAccountRoles(AccountEntryUserRel accountEntryUserRel, DTOConverterContext dtoConverterContext) throws Exception {
        return (AccountRole[])TransformUtil.transformToArray((Collection)accountEntryUserRel.getUserGroupRoles(), userGroupRole -> (AccountRole)this._accountRoleDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)userGroupRole.getPrimaryKey(), dtoConverterContext.getLocale())), AccountRole.class);
    }
}

