/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.account.exception.NoSuchGroupAccountEntryRelException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryService;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.CommerceTermEntryService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountChannelEntry;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.AccountChannelEntry"}, service={DTOConverter.class})
public class AccountChannelEntryDTOConverter
implements DTOConverter<CommerceChannelAccountEntryRel, AccountChannelEntry> {
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceChannelAccountEntryRelService _commerceChannelAccountEntryRelService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommerceTermEntryService _commerceTermEntryService;
    @Reference
    private UserService _userService;

    public String getContentType() {
        return AccountChannelEntry.class.getSimpleName();
    }

    public AccountChannelEntry toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelService.fetchCommerceChannelAccountEntryRel(((Long)dtoConverterContext.getId()).longValue());
        if (commerceChannelAccountEntryRel == null) {
            throw new NoSuchGroupAccountEntryRelException();
        }
        return new AccountChannelEntry(){
            {
                this.setAccountExternalReferenceCode(() -> {
                    AccountEntry accountEntry = AccountChannelEntryDTOConverter.this._accountEntryService.fetchAccountEntry(commerceChannelAccountEntryRel.getAccountEntryId());
                    if (accountEntry != null && !Validator.isBlank((String)accountEntry.getExternalReferenceCode())) {
                        return accountEntry.getExternalReferenceCode();
                    }
                    return null;
                });
                this.setAccountId(() -> ((CommerceChannelAccountEntryRel)commerceChannelAccountEntryRel).getAccountEntryId());
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setChannelExternalReferenceCode(() -> {
                    CommerceChannel commerceChannel = AccountChannelEntryDTOConverter.this._commerceChannelLocalService.fetchCommerceChannel(commerceChannelAccountEntryRel.getCommerceChannelId());
                    if (commerceChannel != null && !Validator.isBlank((String)commerceChannel.getExternalReferenceCode())) {
                        return commerceChannel.getExternalReferenceCode();
                    }
                    return null;
                });
                this.setChannelId(() -> commerceChannelAccountEntryRel.getCommerceChannelId());
                this.setClassExternalReferenceCode(() -> AccountChannelEntryDTOConverter.this._toClassExternalReferenceCode(commerceChannelAccountEntryRel));
                this.setClassPK(() -> ((CommerceChannelAccountEntryRel)commerceChannelAccountEntryRel).getClassPK());
                this.setId(() -> commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId());
                this.setOverrideEligibility(() -> commerceChannelAccountEntryRel.isOverrideEligibility());
                this.setPriority(() -> ((CommerceChannelAccountEntryRel)commerceChannelAccountEntryRel).getPriority());
            }
        };
    }

    private String _toClassExternalReferenceCode(CommerceChannelAccountEntryRel commerceChannelAccountEntryRel) throws Exception {
        User user;
        int type = commerceChannelAccountEntryRel.getType();
        if (type == 2 || type == 3) {
            CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(GetterUtil.getLong((Object)commerceChannelAccountEntryRel.getClassPK()));
            if (!Validator.isBlank((String)commerceAddress.getExternalReferenceCode())) {
                return commerceAddress.getExternalReferenceCode();
            }
        } else if (type == 0) {
            CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.getCommerceTermEntry(GetterUtil.getLong((Object)commerceChannelAccountEntryRel.getClassPK()));
            if (!Validator.isBlank((String)commerceTermEntry.getExternalReferenceCode())) {
                return commerceTermEntry.getExternalReferenceCode();
            }
        } else if (type == 5) {
            CommerceDiscount commerceDiscount = this._commerceDiscountService.getCommerceDiscount(GetterUtil.getLong((Object)commerceChannelAccountEntryRel.getClassPK()));
            if (!Validator.isBlank((String)commerceDiscount.getExternalReferenceCode())) {
                return commerceDiscount.getExternalReferenceCode();
            }
        } else if (type == 8) {
            CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(GetterUtil.getLong((Object)commerceChannelAccountEntryRel.getClassPK()));
            if (!Validator.isBlank((String)commercePaymentMethodGroupRel.getPaymentIntegrationKey())) {
                return commercePaymentMethodGroupRel.getPaymentIntegrationKey();
            }
        } else if (type == 1) {
            CommerceTermEntry commerceTermEntry = this._commerceTermEntryService.getCommerceTermEntry(GetterUtil.getLong((Object)commerceChannelAccountEntryRel.getClassPK()));
            if (!Validator.isBlank((String)commerceTermEntry.getExternalReferenceCode())) {
                return commerceTermEntry.getExternalReferenceCode();
            }
        } else if (type == 4) {
            CommercePriceList commercePriceList = this._commercePriceListService.getCommercePriceList(GetterUtil.getLong((Object)commerceChannelAccountEntryRel.getClassPK()));
            if (!Validator.isBlank((String)commercePriceList.getExternalReferenceCode())) {
                return commercePriceList.getExternalReferenceCode();
            }
        } else if (type == 7 && !Validator.isBlank((String)(user = this._userService.getUserById(GetterUtil.getLong((Object)commerceChannelAccountEntryRel.getClassPK()))).getExternalReferenceCode())) {
            return user.getExternalReferenceCode();
        }
        return null;
    }
}

