/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryService;
import com.liferay.account.service.AccountEntryUserRelService;
import com.liferay.commerce.util.CommerceAccountHelper;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountMemberResourceImpl;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountMemberUtil;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountMemberResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Deprecated
@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-member.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={AccountMemberResource.class})
public class AccountMemberResourceImpl
extends BaseAccountMemberResourceImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private AccountEntryUserRelService _accountEntryUserRelService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountMemberDTOConverter)")
    private DTOConverter<AccountEntryUserRel, AccountMember> _accountMemberDTOConverter;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Response deleteAccountByExternalReferenceCodeAccountMember(String externalReferenceCode, Long userId) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.getAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this._accountEntryUserRelService.deleteAccountEntryUserRels(accountEntry.getAccountEntryId(), new long[]{userId});
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountIdAccountMember(Long id, Long userId) throws Exception {
        this._accountEntryUserRelService.deleteAccountEntryUserRels(id.longValue(), new long[]{userId});
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public AccountMember getAccountByExternalReferenceCodeAccountMember(String externalReferenceCode, Long userId) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.getAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        AccountEntryUserRel accountEntryUserRel = this._accountEntryUserRelService.getAccountEntryUserRel(accountEntry.getAccountEntryId(), userId.longValue());
        return (AccountMember)this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntryUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<AccountMember> getAccountByExternalReferenceCodeAccountMembersPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.getAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        List accountEntryUserRels = this._accountEntryUserRelService.getAccountEntryUserRelsByAccountEntryId(accountEntry.getAccountEntryId(), pagination.getStartPosition(), pagination.getEndPosition());
        long totalItems = this._accountEntryUserRelService.getAccountEntryUserRelsCountByAccountEntryId(accountEntry.getAccountEntryId());
        return Page.of(this._toAccountMembers(accountEntryUserRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public AccountMember getAccountIdAccountMember(Long id, Long userId) throws Exception {
        AccountEntryUserRel accountEntryUserRel = this._accountEntryUserRelService.getAccountEntryUserRel(id.longValue(), userId.longValue());
        return (AccountMember)this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntryUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Account.class, value="accountMembers")
    public Page<AccountMember> getAccountIdAccountMembersPage(Long id, Pagination pagination) throws Exception {
        List accountEntryUserRels = this._accountEntryUserRelService.getAccountEntryUserRelsByAccountEntryId(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        long totalItems = this._accountEntryUserRelService.getAccountEntryUserRelsCountByAccountEntryId(id.longValue());
        return Page.of(this._toAccountMembers(accountEntryUserRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Response patchAccountByExternalReferenceCodeAccountMember(String externalReferenceCode, Long userId, AccountMember accountMember) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.getAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this._updateAccountEntryUserRel(accountEntry, this._userLocalService.getUser(userId.longValue()), accountMember);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountIdAccountMember(Long id, Long userId, AccountMember accountMember) throws Exception {
        this._updateAccountEntryUserRel(this._accountEntryLocalService.getAccountEntry(id.longValue()), this._userLocalService.getUser(userId.longValue()), accountMember);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AccountMember postAccountByExternalReferenceCodeAccountMember(String externalReferenceCode, AccountMember accountMember) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.getAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        AccountEntryUserRel accountEntryUserRel = AccountMemberUtil.addAccountEntryUserRel(this._accountEntryModelResourcePermission, this._accountEntryUserRelService, accountMember, accountEntry, this._commerceAccountHelper, AccountMemberUtil.getUser(this._userLocalService, accountMember, this.contextCompany.getCompanyId()), this._serviceContextHelper.getServiceContext());
        return (AccountMember)this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntryUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public AccountMember postAccountIdAccountMember(Long id, AccountMember accountMember) throws Exception {
        AccountEntryUserRel accountEntryUserRel = AccountMemberUtil.addAccountEntryUserRel(this._accountEntryModelResourcePermission, this._accountEntryUserRelService, accountMember, this._accountEntryLocalService.getAccountEntry(id.longValue()), this._commerceAccountHelper, AccountMemberUtil.getUser(this._userLocalService, accountMember, this.contextCompany.getCompanyId()), this._serviceContextHelper.getServiceContext());
        return (AccountMember)this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntryUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<AccountMember> _toAccountMembers(List<AccountEntryUserRel> accountEntryUserRels) throws Exception {
        return this.transform(accountEntryUserRels, accountEntryUserRel -> (AccountMember)this._accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntryUserRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale())));
    }

    private void _updateAccountEntryUserRel(AccountEntry accountEntry, User user, AccountMember accountMember) throws Exception {
        this._userGroupRoleLocalService.deleteUserGroupRoles(user.getUserId(), new long[]{accountEntry.getAccountEntryGroupId()});
        AccountRole[] accountRoles = accountMember.getAccountRoles();
        if (accountRoles != null) {
            this._userGroupRoleLocalService.addUserGroupRoles(user.getUserId(), accountEntry.getAccountEntryGroupId(), this.transformToLongArray(Arrays.asList(accountRoles), AccountRole::getRoleId));
        }
    }
}

