/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountEntryService;
import com.liferay.account.service.AccountGroupService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AdminAccountGroup;
import com.liferay.headless.commerce.admin.account.internal.odata.entity.v1_0.AccountGroupEntityModel;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAdminAccountGroupResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AdminAccountGroupResource;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Deprecated
@Component(properties={"OSGI-INF/liferay/rest/v1_0/admin-account-group.properties"}, scope=ServiceScope.PROTOTYPE, service={AdminAccountGroupResource.class})
public class AdminAccountGroupResourceImpl
extends BaseAdminAccountGroupResourceImpl {
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private AccountGroupService _accountGroupService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AdminAccountGroupDTOConverter)")
    private DTOConverter<AccountGroup, AdminAccountGroup> _adminAccountGroupDTOConverter;
    private final EntityModel _entityModel = new AccountGroupEntityModel();
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteAccountGroup(Long id) throws Exception {
        this._accountGroupService.deleteAccountGroup(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        AccountGroup accountGroup = this._accountGroupService.getAccountGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this._accountGroupService.deleteAccountGroup(accountGroup.getAccountGroupId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<AdminAccountGroup> getAccountByExternalReferenceCodeAccountGroupsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        return this._getAdminAccountGroups(accountEntry.getAccountEntryId(), pagination);
    }

    @Override
    public AdminAccountGroup getAccountGroup(Long id) throws Exception {
        return (AdminAccountGroup)this._adminAccountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)GetterUtil.getLong((Object)id), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public AdminAccountGroup getAccountGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        AccountGroup accountGroup = this._accountGroupService.getAccountGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return (AdminAccountGroup)this._adminAccountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountGroup.getAccountGroupId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<AdminAccountGroup> getAccountGroupsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)AccountGroup.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toAccountGroup(this._accountGroupService.getAccountGroup(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public Page<AdminAccountGroup> getAccountIdAccountGroupsPage(Long id, Pagination pagination) throws Exception {
        return this._getAdminAccountGroups(id, pagination);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return this._entityModel;
    }

    @Override
    public Response patchAccountGroup(Long id, AdminAccountGroup adminAccountGroup) throws Exception {
        this._accountGroupService.updateAccountGroup(adminAccountGroup.getExternalReferenceCode(), id.longValue(), adminAccountGroup.getDescription(), adminAccountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountGroupByExternalReferenceCode(String externalReferenceCode, AdminAccountGroup adminAccountGroup) throws Exception {
        AccountGroup accountGroup = this._accountGroupService.getAccountGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this._accountGroupService.updateAccountGroup(externalReferenceCode, accountGroup.getAccountGroupId(), adminAccountGroup.getDescription(), adminAccountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Map customFields = adminAccountGroup.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), AccountGroup.class, (long)accountGroup.getPrimaryKey(), (Map)customFields);
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AdminAccountGroup postAccountGroup(AdminAccountGroup adminAccountGroup) throws Exception {
        AccountGroup accountGroup = null;
        if (Validator.isNotNull((String)adminAccountGroup.getExternalReferenceCode())) {
            accountGroup = this._accountGroupService.fetchAccountGroupByExternalReferenceCode(adminAccountGroup.getExternalReferenceCode(), this.contextCompany.getCompanyId());
        }
        accountGroup = accountGroup == null ? this._accountGroupService.addAccountGroup(adminAccountGroup.getExternalReferenceCode(), this.contextUser.getUserId(), adminAccountGroup.getDescription(), adminAccountGroup.getName(), this._serviceContextHelper.getServiceContext()) : this._accountGroupService.updateAccountGroup(adminAccountGroup.getExternalReferenceCode(), accountGroup.getAccountGroupId(), adminAccountGroup.getDescription(), adminAccountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Map customFields = adminAccountGroup.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), AccountGroup.class, (long)accountGroup.getPrimaryKey(), (Map)customFields);
        }
        return (AdminAccountGroup)this._adminAccountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountGroup.getAccountGroupId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private Page<AdminAccountGroup> _getAdminAccountGroups(long accountEntryId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._accountGroupService.getAccountGroupsByAccountEntryId(accountEntryId, pagination.getStartPosition(), pagination.getEndPosition()), accountGroup -> this._toAccountGroup((AccountGroup)accountGroup)), (Pagination)pagination, (long)this._accountGroupService.getAccountGroupsCountByAccountEntryId(accountEntryId));
    }

    private AdminAccountGroup _toAccountGroup(AccountGroup accountGroup) throws Exception {
        return (AdminAccountGroup)this._adminAccountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountGroup.getAccountGroupId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

