/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountGroupException;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountGroup;
import com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountGroupDTOConverter;
import com.liferay.headless.commerce.admin.account.internal.odata.entity.v1_0.AccountGroupEntityModel;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountGroupResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountGroupResource;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/account-group.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountGroupResource.class})
public class AccountGroupResourceImpl
extends BaseAccountGroupResourceImpl
implements EntityModelResource {
    @Reference
    private AccountGroupDTOConverter _accountGroupDTOConverter;
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    private final EntityModel _entityModel = new AccountGroupEntityModel();
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteAccountGroup(Long id) throws Exception {
        this._commerceAccountGroupService.deleteCommerceAccountGroup(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccountGroup == null) {
            throw new NoSuchAccountGroupException("Unable to find AccountGroup with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAccountGroupService.deleteCommerceAccountGroup(commerceAccountGroup.getCommerceAccountGroupId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AccountGroup getAccountGroup(Long id) throws Exception {
        return this._accountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)GetterUtil.getLong((Object)id), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public AccountGroup getAccountGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccountGroup == null) {
            throw new NoSuchAccountGroupException("Unable to find AccountGroup with externalReferenceCode: " + externalReferenceCode);
        }
        return this._accountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountGroup.getCommerceAccountGroupId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<AccountGroup> getAccountGroupsPage(Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CommerceAccountGroup.class, (String)"", (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setCompanyId(AccountGroupResourceImpl.this.contextCompany.getCompanyId());
            }
        }, document -> this._toAccountGroup(this._commerceAccountGroupService.getCommerceAccountGroup(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return this._entityModel;
    }

    @Override
    public Response patchAccountGroup(Long id, AccountGroup accountGroup) throws Exception {
        this._commerceAccountGroupService.updateCommerceAccountGroup(id.longValue(), accountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountGroupByExternalReferenceCode(String externalReferenceCode, AccountGroup accountGroup) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccountGroup == null) {
            throw new NoSuchAccountGroupException("Unable to find AccountGroup with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAccountGroupService.updateCommerceAccountGroup(commerceAccountGroup.getCommerceAccountGroupId(), accountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Map customFields = accountGroup.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceAccountGroup.class, (long)commerceAccountGroup.getPrimaryKey(), (Map)customFields);
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AccountGroup postAccountGroup(AccountGroup accountGroup) throws Exception {
        CommerceAccountGroup commerceAccountGroup = null;
        if (Validator.isNotNull((String)accountGroup.getExternalReferenceCode())) {
            commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), accountGroup.getExternalReferenceCode());
        }
        commerceAccountGroup = commerceAccountGroup == null ? this._commerceAccountGroupService.addCommerceAccountGroup(this.contextCompany.getCompanyId(), accountGroup.getName(), 0, accountGroup.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext()) : this._commerceAccountGroupService.updateCommerceAccountGroup(commerceAccountGroup.getCommerceAccountGroupId(), accountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Map customFields = accountGroup.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceAccountGroup.class, (long)commerceAccountGroup.getPrimaryKey(), (Map)customFields);
        }
        return this._accountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountGroup.getCommerceAccountGroupId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private AccountGroup _toAccountGroup(CommerceAccountGroup commerceAccountGroup) throws Exception {
        return this._accountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountGroup.getCommerceAccountGroupId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

