/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountOrganizationRel;
import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountOrganizationRelService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.account.service.CommerceAccountUserRelService;
import com.liferay.commerce.account.service.persistence.CommerceAccountOrganizationRelPK;
import com.liferay.commerce.account.service.persistence.CommerceAccountUserRelPK;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountResourceImpl;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountMemberUtil;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountOrganizationUtil;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountResource.class})
public class AccountResourceImpl
extends BaseAccountResourceImpl {
    @Reference
    private CommerceAccountOrganizationRelService _commerceAccountOrganizationRelService;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAccountUserRelService _commerceAccountUserRelService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Response deleteAccount(Long id) throws Exception {
        this._commerceAccountService.deleteCommerceAccount(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAccountService.deleteCommerceAccount(commerceAccount.getCommerceAccountId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Account getAccount(Long id) throws Exception {
        DTOConverter accountDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccount.class.getName());
        return (Account)accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), GetterUtil.getLong((Object)id)));
    }

    @Override
    public Account getAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter accountDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccount.class.getName());
        return (Account)accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccount.getCommerceAccountId()));
    }

    @Override
    public Page<Account> getAccountsPage(Pagination pagination) throws Exception {
        List commerceAccounts = this._commerceAccountService.getUserCommerceAccounts(this._user.getUserId(), 0L, 2, null, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceAccountService.getUserCommerceAccountsCount(this._user.getUserId(), 0L, 2, null);
        return Page.of(this._toAccounts(commerceAccounts), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Response patchAccount(Long id, Account account) throws Exception {
        this._updateAccount(id, account);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountByExternalReferenceCode(String externalReferenceCode, Account account) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateAccount(commerceAccount.getCommerceAccountId(), account);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Account postAccount(Account account) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.upsertCommerceAccount(account.getName(), 0L, true, null, this._getEmailAddress(account, null), account.getTaxId(), GetterUtil.get((Object)account.getType(), (int)1), true, account.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext());
        Map customFields = account.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceAccount.class, (long)commerceAccount.getPrimaryKey(), (Map)customFields);
        }
        this._updateNestedResources(account, commerceAccount, this._serviceContextHelper.getServiceContext());
        DTOConverter accountDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccount.class.getName());
        return (Account)accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccount.getCommerceAccountId()));
    }

    @Override
    public Response postAccountByExternalReferenceCodeLogo(String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        this.updateAccountLogo(commerceAccount, multipartBody);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response postAccountLogo(Long id, MultipartBody multipartBody) throws Exception {
        this.updateAccountLogo(this._commerceAccountService.getCommerceAccount(id.longValue()), multipartBody);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    public void updateAccountLogo(CommerceAccount commerceAccount, MultipartBody multipartBody) throws IOException, PortalException {
        this._commerceAccountService.updateCommerceAccount(commerceAccount.getCommerceAccountId(), commerceAccount.getName(), true, multipartBody.getBinaryFileAsBytes("logo"), commerceAccount.getEmail(), commerceAccount.getTaxId(), commerceAccount.isActive(), this._serviceContextHelper.getServiceContext(commerceAccount.getCommerceAccountGroupId()));
    }

    private String _getEmailAddress(Account account, CommerceAccount commerceAccount) {
        String[] emailAddresses = new String[]{};
        if (account.getEmailAddresses() != null) {
            emailAddresses = account.getEmailAddresses();
        }
        if (emailAddresses.length > 0) {
            return emailAddresses[0];
        }
        if (commerceAccount == null) {
            return "";
        }
        return commerceAccount.getEmail();
    }

    private List<Account> _toAccounts(List<CommerceAccount> commerceAccounts) throws Exception {
        ArrayList<Account> accounts = new ArrayList<Account>();
        DTOConverter accountDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccount.class.getName());
        for (CommerceAccount commerceAccount : commerceAccounts) {
            accounts.add((Account)accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccount.getCommerceAccountId())));
        }
        return accounts;
    }

    private CommerceAccount _updateAccount(Long id, Account account) throws PortalException {
        CommerceAccount commerceAccount = this._commerceAccountService.getCommerceAccount(id.longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceAccount.getCommerceAccountGroupId());
        commerceAccount = this._commerceAccountService.updateCommerceAccount(commerceAccount.getCommerceAccountId(), account.getName(), true, null, this._getEmailAddress(account, commerceAccount), GetterUtil.get((String)account.getTaxId(), (String)commerceAccount.getTaxId()), commerceAccount.isActive(), serviceContext);
        Map customFields = account.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommerceAccount.class, (long)commerceAccount.getPrimaryKey(), (Map)customFields);
        }
        this._updateNestedResources(account, commerceAccount, serviceContext);
        return commerceAccount;
    }

    private CommerceAccount _updateNestedResources(Account account, CommerceAccount commerceAccount, ServiceContext serviceContext) throws PortalException {
        AccountOrganization[] accountOrganizations;
        AccountMember[] accountMembers;
        AccountAddress[] accountAddresses = account.getAddresses();
        if (accountAddresses != null) {
            for (AccountAddress accountAddress : accountAddresses) {
                this._commerceAddressService.addCommerceAddress(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), accountAddress.getName(), accountAddress.getDescription(), accountAddress.getStreet1(), accountAddress.getStreet2(), accountAddress.getStreet3(), accountAddress.getCity(), accountAddress.getZip(), accountAddress.getCommerceRegionId().longValue(), accountAddress.getCommerceCountryId().longValue(), accountAddress.getPhoneNumber(), GetterUtil.get((Object)accountAddress.getDefaultBilling(), (boolean)false), GetterUtil.get((Object)accountAddress.getDefaultShipping(), (boolean)false), serviceContext);
            }
        }
        if ((accountMembers = account.getUsers()) != null) {
            for (AccountMember accountMember : accountMembers) {
                User user = AccountMemberUtil.getUser(this._userLocalService, accountMember, this.contextCompany.getCompanyId());
                CommerceAccountUserRel commerceAccountUserRel = this._commerceAccountUserRelService.fetchCommerceAccountUserRel(new CommerceAccountUserRelPK(commerceAccount.getCommerceAccountId(), user.getUserId()));
                if (commerceAccountUserRel != null) continue;
                AccountMemberUtil.addCommerceAccountUserRel(this._commerceAccountUserRelService, accountMember, commerceAccount, user, serviceContext);
            }
        }
        if ((accountOrganizations = account.getOrganizations()) != null) {
            for (AccountOrganization accountOrganization : accountOrganizations) {
                long organizationId = AccountOrganizationUtil.getOrganizationId(this._organizationLocalService, accountOrganization, this.contextCompany.getCompanyId());
                CommerceAccountOrganizationRel commerceAccountOrganizationRel = this._commerceAccountOrganizationRelService.fetchCommerceAccountOrganizationRel(new CommerceAccountOrganizationRelPK(commerceAccount.getCommerceAccountId(), organizationId));
                if (commerceAccountOrganizationRel != null) continue;
                this._commerceAccountOrganizationRelService.addCommerceAccountOrganizationRel(commerceAccount.getCommerceAccountId(), organizationId, serviceContext);
            }
        }
        return commerceAccount;
    }
}

