/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceAddress"}, service={AccountAddressDTOConverter.class, DTOConverter.class})
public class AccountAddressDTOConverter
implements DTOConverter {
    @Reference
    private CommerceAddressService _commerceAddressService;

    public String getContentType() {
        return AccountAddress.class.getSimpleName();
    }

    public AccountAddress toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(dtoConverterContext.getResourcePrimKey());
        return new AccountAddress(){
            {
                this.city = commerceAddress.getCity();
                this.commerceCountryId = commerceAddress.getCommerceCountryId();
                this.commerceRegionId = commerceAddress.getCommerceRegionId();
                this.defaultBilling = commerceAddress.isDefaultBilling();
                this.defaultShipping = commerceAddress.isDefaultShipping();
                this.description = commerceAddress.getDescription();
                this.id = commerceAddress.getCommerceAddressId();
                this.latitude = commerceAddress.getLatitude();
                this.longitude = commerceAddress.getLongitude();
                this.name = commerceAddress.getName();
                this.phoneNumber = commerceAddress.getPhoneNumber();
                this.street1 = commerceAddress.getStreet1();
                this.street2 = commerceAddress.getStreet2();
                this.street3 = commerceAddress.getStreet3();
                this.zip = commerceAddress.getZip();
            }
        };
    }
}

