/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.account.internal.util.v1_0;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountUserRelService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Validator;

import java.util.Arrays;
import java.util.stream.Stream;

/**
 * @author Alessio Antonio Rendina
 */
public class AccountMemberUtil {

	public static CommerceAccountUserRel addCommerceAccountUserRel(
			CommerceAccountUserRelService commerceAccountUserRelService,
			AccountMember accountMember, CommerceAccount commerceAccount,
			User user, ServiceContext serviceContext)
		throws PortalException {

		long[] roleIds = null;

		AccountRole[] accountRoles = accountMember.getAccountRoles();

		if (accountRoles != null) {
			Stream<AccountRole> accountRoleStream = Arrays.stream(accountRoles);

			roleIds = accountRoleStream.mapToLong(
				AccountRole::getRoleId
			).toArray();
		}

		return commerceAccountUserRelService.addCommerceAccountUserRel(
			commerceAccount.getCommerceAccountId(), user.getUserId(), roleIds,
			serviceContext);
	}

	public static User getUser(
			UserLocalService userLocalService, AccountMember accountMember,
			long companyId)
		throws PortalException {

		User user;

		if (Validator.isNotNull(accountMember.getUserExternalReferenceCode())) {
			user = userLocalService.fetchUserByReferenceCode(
				companyId, accountMember.getUserExternalReferenceCode());

			if (user == null) {
				throw new NoSuchUserException(
					"Unable to find User with externalReferenceCode: " +
						accountMember.getUserExternalReferenceCode());
			}
		}
		else {
			user = userLocalService.getUser(accountMember.getUserId());
		}

		return user;
	}

}