/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Address;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAddressResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AddressResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/address.properties"}, scope=ServiceScope.PROTOTYPE, service={AddressResource.class})
public class AddressResourceImpl
extends BaseAddressResourceImpl {
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Page<Address> getAccountByExternalReferenceCodeAddressesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        return this._getAddressesPage(commerceAccount, pagination);
    }

    @Override
    public Page<Address> getAccountIdAddressesPage(Long id, Pagination pagination) throws Exception {
        return this._getAddressesPage(this._commerceAccountService.getCommerceAccount(id.longValue()), pagination);
    }

    @Override
    public Address postAccountByExternalReferenceCodeAddress(String externalReferenceCode, Address address) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        return this._addAddress(commerceAccount, address);
    }

    @Override
    public Address postAccountIdAddress(Long id, Address address) throws Exception {
        return this._addAddress(this._commerceAccountService.getCommerceAccount(id.longValue()), address);
    }

    private Address _addAddress(CommerceAccount commerceAccount, Address address) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.addCommerceAddress(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), address.getName(), address.getDescription(), address.getStreet1(), address.getStreet2(), address.getStreet3(), address.getCity(), address.getZip(), address.getCommerceRegionId().longValue(), address.getCommerceCountryId().longValue(), address.getPhoneNumber(), GetterUtil.get((Object)address.getDefaultBilling(), (boolean)false), GetterUtil.get((Object)address.getDefaultShipping(), (boolean)false), this._serviceContextHelper.getServiceContext());
        DTOConverter addressDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAddress.class.getName());
        return (Address)addressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAddress.getCommerceAddressId()));
    }

    private Page<Address> _getAddressesPage(CommerceAccount commerceAccount, Pagination pagination) throws Exception {
        List commerceAddresses = this._commerceAddressService.getCommerceAddresses(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceAddressService.getCommerceAddressesCount(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId());
        return Page.of(this._toAddresses(commerceAddresses), (Pagination)pagination, (long)totalItems);
    }

    private List<Address> _toAddresses(List<CommerceAddress> commerceAddresses) throws Exception {
        ArrayList<Address> addresses = new ArrayList<Address>();
        DTOConverter addressDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAddress.class.getName());
        for (CommerceAddress commerceAddress : commerceAddresses) {
            addresses.add((Address)addressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAddress.getCommerceAddressId())));
        }
        return addresses;
    }
}

