/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountUserRelService;
import com.liferay.commerce.account.service.persistence.CommerceAccountUserRelPK;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.account.model.CommerceAccountUserRel"}, service={AccountMemberDTOConverter.class, DTOConverter.class})
public class AccountMemberDTOConverter
implements DTOConverter {
    @Reference
    private CommerceAccountUserRelService _commerceAccountUserRelService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    public String getContentType() {
        return AccountMember.class.getSimpleName();
    }

    public AccountMember toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAccountUserRel commerceAccountUserRel = this._commerceAccountUserRelService.getCommerceAccountUserRel((CommerceAccountUserRelPK)dtoConverterContext.getCompositeResourcePrimKey());
        final User user = commerceAccountUserRel.getUser();
        return new AccountMember(){
            {
                this.commerceAccountId = commerceAccountUserRel.getCommerceAccountId();
                this.name = user.getFullName();
                this.userId = user.getUserId();
                this.roles = AccountMemberDTOConverter.this._getRoles(commerceAccountUserRel, dtoConverterContext);
            }
        };
    }

    private AccountRole[] _getRoles(CommerceAccountUserRel commerceAccountUserRel, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<AccountRole> accountRoles = new ArrayList<AccountRole>();
        DTOConverter accountRoleDTOConverter = this._dtoConverterRegistry.getDTOConverter(UserGroupRole.class.getName());
        for (UserGroupRole userGroupRole : commerceAccountUserRel.getUserGroupRoles()) {
            accountRoles.add((AccountRole)accountRoleDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), (Object)userGroupRole.getPrimaryKey())));
        }
        Stream stream = accountRoles.stream();
        return (AccountRole[])stream.toArray(AccountRole[]::new);
    }
}

