/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountOrganizationRel;
import com.liferay.commerce.account.service.CommerceAccountOrganizationRelService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.account.service.persistence.CommerceAccountOrganizationRelPK;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountOrganizationDTOConverter;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountOrganizationResourceImpl;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountOrganizationUtil;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountOrganizationResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-organization.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountOrganizationResource.class})
public class AccountOrganizationResourceImpl
extends BaseAccountOrganizationResourceImpl {
    @Reference
    private AccountOrganizationDTOConverter _accountOrganizationDTOConverter;
    @Reference
    private CommerceAccountOrganizationRelService _commerceAccountOrganizationRelService;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, Long organizationId) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAccountOrganizationRelService.deleteCommerceAccountOrganizationRel(commerceAccount.getCommerceAccountId(), organizationId.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountIdAccountOrganization(Long id, Long organizationId) throws Exception {
        this._commerceAccountOrganizationRelService.deleteCommerceAccountOrganizationRel(id.longValue(), organizationId.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AccountOrganization getAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, Long organizationId) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceAccountOrganizationRel commerceAccountOrganizationRel = this._commerceAccountOrganizationRelService.getCommerceAccountOrganizationRel(new CommerceAccountOrganizationRelPK(commerceAccount.getCommerceAccountId(), organizationId.longValue()));
        return this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<AccountOrganization> getAccountByExternalReferenceCodeAccountOrganizationsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceAccountOrganizationRels = this._commerceAccountOrganizationRelService.getCommerceAccountOrganizationRels(commerceAccount.getCommerceAccountId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceAccountOrganizationRelService.getCommerceAccountOrganizationRelsCount(commerceAccount.getCommerceAccountId());
        return Page.of(this._toAccountOrganizations(commerceAccountOrganizationRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public AccountOrganization getAccountIdAccountOrganization(Long id, Long organizationId) throws Exception {
        return this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)new CommerceAccountOrganizationRelPK(id.longValue(), organizationId.longValue()), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Account.class, value="organizations")
    public Page<AccountOrganization> getAccountIdAccountOrganizationsPage(Long id, Pagination pagination) throws Exception {
        List commerceAccountOrganizationRels = this._commerceAccountOrganizationRelService.getCommerceAccountOrganizationRels(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceAccountOrganizationRelService.getCommerceAccountOrganizationRelsCount(id.longValue());
        return Page.of(this._toAccountOrganizations(commerceAccountOrganizationRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public AccountOrganization postAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, AccountOrganization accountOrganization) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceAccountOrganizationRel commerceAccountOrganizationRel = this._commerceAccountOrganizationRelService.addCommerceAccountOrganizationRel(commerceAccount.getCommerceAccountId(), AccountOrganizationUtil.getOrganizationId(this._organizationLocalService, accountOrganization, this.contextCompany.getCompanyId()), this._serviceContextHelper.getServiceContext());
        return this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public AccountOrganization postAccountIdAccountOrganization(Long id, AccountOrganization accountOrganization) throws Exception {
        CommerceAccountOrganizationRel commerceAccountOrganizationRel = this._commerceAccountOrganizationRelService.addCommerceAccountOrganizationRel(id.longValue(), AccountOrganizationUtil.getOrganizationId(this._organizationLocalService, accountOrganization, this.contextCompany.getCompanyId()), this._serviceContextHelper.getServiceContext());
        return this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<AccountOrganization> _toAccountOrganizations(List<CommerceAccountOrganizationRel> commerceAccountOrganizationRels) throws Exception {
        ArrayList<AccountOrganization> accountOrganizations = new ArrayList<AccountOrganization>();
        for (CommerceAccountOrganizationRel commerceAccountOrganizationRel : commerceAccountOrganizationRels) {
            accountOrganizations.add(this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return accountOrganizations;
    }
}

