/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.exception.NoSuchAddressException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceCountryService;
import com.liferay.commerce.service.CommerceRegionLocalService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountAddressDTOConverter;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountAddressResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountAddressResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-address.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountAddressResource.class})
public class AccountAddressResourceImpl
extends BaseAccountAddressResourceImpl {
    @Reference
    private AccountAddressDTOConverter _accountAddressDTOConverter;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceCountryService _commerceCountryService;
    @Reference
    private CommerceRegionLocalService _commerceRegionLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteAccountAddressByExternalReferenceCode(@NotNull String externalReferenceCode) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAddress == null) {
            throw new NoSuchAddressException("Unable to find AccountAddress with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAddressService.deleteCommerceAddress(commerceAddress.getCommerceAddressId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public AccountAddress getAccountAddressByExternalReferenceCode(@NotNull String externalReferenceCode) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAddress == null) {
            throw new NoSuchAddressException("Unable to find AccountAddress with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toAccountAddress(commerceAddress);
    }

    @Override
    public Page<AccountAddress> getAccountByExternalReferenceCodeAccountAddressesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        return this._getAccountAddressesPage(commerceAccount, pagination);
    }

    @Override
    @NestedField(parentClass=Account.class, value="addresses")
    public Page<AccountAddress> getAccountIdAccountAddressesPage(Long id, Pagination pagination) throws Exception {
        return this._getAccountAddressesPage(this._commerceAccountService.getCommerceAccount(id.longValue()), pagination);
    }

    @Override
    public Response patchAccountAddressByExternalReferenceCode(@NotNull String externalReferenceCode, AccountAddress accountAddress) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAddress == null) {
            throw new NoSuchAddressException("Unable to find AccountAddress with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAddressService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), GetterUtil.getString((String)accountAddress.getName(), (String)commerceAddress.getName()), GetterUtil.getString((String)accountAddress.getDescription(), (String)commerceAddress.getDescription()), GetterUtil.getString((String)accountAddress.getStreet1(), (String)commerceAddress.getStreet1()), GetterUtil.getString((String)accountAddress.getStreet2(), (String)commerceAddress.getStreet2()), GetterUtil.getString((String)accountAddress.getStreet3(), (String)commerceAddress.getStreet3()), GetterUtil.getString((String)accountAddress.getCity(), (String)commerceAddress.getCity()), GetterUtil.getString((String)accountAddress.getZip(), (String)commerceAddress.getZip()), commerceAddress.getCommerceRegionId(), commerceAddress.getCommerceCountryId(), GetterUtil.getString((String)accountAddress.getPhoneNumber(), (String)commerceAddress.getPhoneNumber()), GetterUtil.getInteger((Object)accountAddress.getType(), (int)commerceAddress.getType()), this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public AccountAddress postAccountByExternalReferenceCodeAccountAddress(String externalReferenceCode, AccountAddress accountAddress) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceAddress commerceAddress = null;
        if (accountAddress.getId() != null) {
            commerceAddress = this._commerceAddressService.fetchCommerceAddress(accountAddress.getId().longValue());
        } else if (accountAddress.getExternalReferenceCode() != null) {
            commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), accountAddress.getExternalReferenceCode());
        }
        if (commerceAddress != null) {
            return this._toAccountAddress(this._commerceAddressService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), GetterUtil.getString((String)accountAddress.getName(), null), GetterUtil.getString((String)accountAddress.getDescription(), null), GetterUtil.getString((String)accountAddress.getStreet1(), null), GetterUtil.getString((String)accountAddress.getStreet2(), null), GetterUtil.getString((String)accountAddress.getStreet3(), null), GetterUtil.getString((String)accountAddress.getCity(), null), GetterUtil.getString((String)accountAddress.getZip(), null), commerceAddress.getCommerceRegionId(), commerceAddress.getCommerceCountryId(), GetterUtil.getString((String)accountAddress.getPhoneNumber(), null), GetterUtil.getInteger((Object)accountAddress.getType(), (int)commerceAddress.getType()), this._serviceContextHelper.getServiceContext()));
        }
        return this._addAccountAddress(commerceAccount, accountAddress);
    }

    @Override
    public AccountAddress postAccountIdAccountAddress(Long id, AccountAddress accountAddress) throws Exception {
        return this._addAccountAddress(this._commerceAccountService.getCommerceAccount(id.longValue()), accountAddress);
    }

    private AccountAddress _addAccountAddress(CommerceAccount commerceAccount, AccountAddress accountAddress) throws Exception {
        CommerceCountry commerceCountry = this._commerceCountryService.getCommerceCountry(commerceAccount.getCompanyId(), accountAddress.getCountryISOCode());
        CommerceAddress commerceAddress = this._commerceAddressService.addCommerceAddress(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), accountAddress.getName(), accountAddress.getDescription(), accountAddress.getStreet1(), accountAddress.getStreet2(), accountAddress.getStreet3(), accountAddress.getCity(), accountAddress.getZip(), this._getCommerceRegionId(commerceCountry, accountAddress), commerceCountry.getCommerceCountryId(), accountAddress.getPhoneNumber(), GetterUtil.getInteger((Object)accountAddress.getType(), (int)2), GetterUtil.getString((String)accountAddress.getExternalReferenceCode(), null), this._serviceContextHelper.getServiceContext());
        return this._accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private Page<AccountAddress> _getAccountAddressesPage(CommerceAccount commerceAccount, Pagination pagination) throws Exception {
        List commerceAddresses = this._commerceAddressService.getCommerceAddresses(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceAddressService.getCommerceAddressesCount(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId());
        return Page.of(this._toAccountAddresses(commerceAddresses), (Pagination)pagination, (long)totalItems);
    }

    private long _getCommerceRegionId(CommerceCountry commerceCountry, AccountAddress accountAddress) throws PortalException {
        if (Validator.isNull((String)accountAddress.getRegionISOCode()) || commerceCountry == null) {
            return 0L;
        }
        CommerceRegion commerceRegion = this._commerceRegionLocalService.getCommerceRegion(commerceCountry.getCommerceCountryId(), accountAddress.getRegionISOCode());
        return commerceRegion.getCommerceRegionId();
    }

    private AccountAddress _toAccountAddress(CommerceAddress commerceAddress) throws Exception {
        return this._accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<AccountAddress> _toAccountAddresses(List<CommerceAddress> commerceAddresses) throws Exception {
        ArrayList<AccountAddress> accountAddresses = new ArrayList<AccountAddress>();
        for (CommerceAddress commerceAddress : commerceAddresses) {
            accountAddresses.add(this._accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return accountAddresses;
    }
}

