/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.account.model.CommerceAccount"}, service={AccountDTOConverter.class, DTOConverter.class})
public class AccountDTOConverter
implements DTOConverter {
    @Reference
    private CommerceAccountService _commerceAccountService;

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public Account toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAccount commerceAccount = this._commerceAccountService.getCommerceAccount(dtoConverterContext.getResourcePrimKey());
        final ExpandoBridge expandoBridge = commerceAccount.getExpandoBridge();
        return new Account(){
            {
                this.customFields = expandoBridge.getAttributes();
                this.emailAddresses = new String[]{commerceAccount.getEmail()};
                this.externalReferenceCode = commerceAccount.getExternalReferenceCode();
                this.id = commerceAccount.getCommerceAccountId();
                this.logoId = commerceAccount.getLogoId();
                this.name = commerceAccount.getName();
                this.root = commerceAccount.isRoot();
                this.taxId = commerceAccount.getTaxId();
                this.type = commerceAccount.getType();
            }
        };
    }
}

