/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountResource.class})
public class AccountResourceImpl
extends BaseAccountResourceImpl {
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Context
    private User _user;

    @Override
    public Response deleteAccount(Long id) throws Exception {
        this._commerceAccountService.deleteCommerceAccount(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAccountService.deleteCommerceAccount(commerceAccount.getCommerceAccountId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Account getAccount(Long id) throws Exception {
        DTOConverter accountDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccount.class.getName());
        return (Account)accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), (Object)id));
    }

    @Override
    public Account getAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter accountDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccount.class.getName());
        return (Account)accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccount.getCommerceAccountId()));
    }

    @Override
    public Page<Account> getAccountsPage(Pagination pagination) throws Exception {
        List commerceAccounts = this._commerceAccountService.getUserCommerceAccounts(this._user.getUserId(), 0L, 2, null, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceAccountService.getUserCommerceAccountsCount(this._user.getUserId(), 0L, 2, null);
        return Page.of(this._toAccounts(commerceAccounts), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Response patchAccount(Long id, Account account) throws Exception {
        this._updateAccount(id, account);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountByExternalReferenceCode(String externalReferenceCode, Account account) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateAccount(commerceAccount.getCommerceAccountId(), account);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Account postAccount(Account account) throws Exception {
        DTOConverter accountDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccount.class.getName());
        CommerceAccount commerceAccount = this._commerceAccountService.upsertCommerceAccount(account.getName(), 0L, true, null, this._getEmailAddress(account, null), account.getTaxId(), 1, true, account.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext());
        return (Account)accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccount.getCommerceAccountId()));
    }

    @Override
    public Response postAccountByExternalReferenceCodeLogo(String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        this.updateAccountLogo(commerceAccount, multipartBody);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response postAccountLogo(Long id, MultipartBody multipartBody) throws Exception {
        this.updateAccountLogo(this._commerceAccountService.getCommerceAccount(id.longValue()), multipartBody);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    public void updateAccountLogo(CommerceAccount commerceAccount, MultipartBody multipartBody) throws IOException, PortalException {
        this._commerceAccountService.updateCommerceAccount(commerceAccount.getCommerceAccountId(), commerceAccount.getName(), true, multipartBody.getBinaryFileAsBytes("logo"), commerceAccount.getEmail(), commerceAccount.getTaxId(), commerceAccount.isActive(), this._serviceContextHelper.getServiceContext(commerceAccount.getCommerceAccountGroupId()));
    }

    private String _getEmailAddress(Account account, CommerceAccount commerceAccount) {
        String[] emailAddresses = new String[]{};
        if (account.getEmailAddresses() != null) {
            emailAddresses = account.getEmailAddresses();
        }
        if (emailAddresses.length > 0) {
            return emailAddresses[0];
        }
        if (commerceAccount == null) {
            throw new ClientErrorException("Email address should be specified in the request body", Response.Status.CONFLICT);
        }
        return commerceAccount.getEmail();
    }

    private List<Account> _toAccounts(List<CommerceAccount> commerceAccounts) throws Exception {
        ArrayList<Account> accounts = new ArrayList<Account>();
        DTOConverter accountDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccount.class.getName());
        for (CommerceAccount commerceAccount : commerceAccounts) {
            accounts.add((Account)accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccount.getCommerceAccountId())));
        }
        return accounts;
    }

    private CommerceAccount _updateAccount(Long id, Account account) throws PortalException {
        CommerceAccount commerceAccount = this._commerceAccountService.getCommerceAccount(id.longValue());
        return this._commerceAccountService.updateCommerceAccount(commerceAccount.getCommerceAccountId(), account.getName(), true, null, this._getEmailAddress(account, commerceAccount), GetterUtil.get((String)account.getTaxId(), (String)commerceAccount.getTaxId()), commerceAccount.isActive(), this._serviceContextHelper.getServiceContext(commerceAccount.getCommerceAccountGroupId()));
    }
}

