/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountGroupException;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountGroup;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountGroupResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountGroupResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-group.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountGroupResource.class})
public class AccountGroupResourceImpl
extends BaseAccountGroupResourceImpl {
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteAccountGroup(Long id) throws Exception {
        this._commerceAccountGroupService.deleteCommerceAccountGroup(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccountGroup == null) {
            throw new NoSuchAccountGroupException("Unable to find AccountGroup with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAccountGroupService.deleteCommerceAccountGroup(commerceAccountGroup.getCommerceAccountGroupId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AccountGroup getAccountGroup(Long id) throws Exception {
        DTOConverter accountGroupDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccountGroup.class.getName());
        return (AccountGroup)accountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), GetterUtil.getLong((Object)id)));
    }

    @Override
    public AccountGroup getAccountGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccountGroup == null) {
            throw new NoSuchAccountGroupException("Unable to find AccountGroup with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter accountGroupDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccountGroup.class.getName());
        return (AccountGroup)accountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccountGroup.getCommerceAccountGroupId()));
    }

    @Override
    public Page<AccountGroup> getAccountGroupsPage(Pagination pagination) throws Exception {
        List commerceAccountGroups = this._commerceAccountGroupService.getCommerceAccountGroups(this.contextCompany.getCompanyId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceAccountGroupService.getCommerceAccountGroupsCount(this.contextCompany.getCompanyId());
        return Page.of(this._toAccountGroups(commerceAccountGroups), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Response patchAccountGroup(Long id, AccountGroup accountGroup) throws Exception {
        this._commerceAccountGroupService.updateCommerceAccountGroup(id.longValue(), accountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchAccountGroupByExternalReferenceCode(String externalReferenceCode, AccountGroup accountGroup) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccountGroup == null) {
            throw new NoSuchAccountGroupException("Unable to find AccountGroup with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceAccountGroupService.updateCommerceAccountGroup(commerceAccountGroup.getCommerceAccountGroupId(), accountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Map customFields = accountGroup.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceAccountGroup.class, (long)commerceAccountGroup.getPrimaryKey(), (Map)customFields);
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AccountGroup postAccountGroup(AccountGroup accountGroup) throws Exception {
        CommerceAccountGroup commerceAccountGroup = null;
        if (Validator.isNotNull((String)accountGroup.getExternalReferenceCode())) {
            commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), accountGroup.getExternalReferenceCode());
        }
        commerceAccountGroup = commerceAccountGroup == null ? this._commerceAccountGroupService.addCommerceAccountGroup(this.contextCompany.getCompanyId(), accountGroup.getName(), 0, accountGroup.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext()) : this._commerceAccountGroupService.updateCommerceAccountGroup(commerceAccountGroup.getCommerceAccountGroupId(), accountGroup.getName(), this._serviceContextHelper.getServiceContext());
        Map customFields = accountGroup.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceAccountGroup.class, (long)commerceAccountGroup.getPrimaryKey(), (Map)customFields);
        }
        DTOConverter accountGroupDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccountGroup.class.getName());
        return (AccountGroup)accountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccountGroup.getCommerceAccountGroupId()));
    }

    private List<AccountGroup> _toAccountGroups(List<CommerceAccountGroup> commerceAccountGroups) throws Exception {
        ArrayList<AccountGroup> accountGroups = new ArrayList<AccountGroup>();
        DTOConverter accountGroupDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccountGroup.class.getName());
        for (CommerceAccountGroup commerceAccountGroup : commerceAccountGroups) {
            accountGroups.add((AccountGroup)accountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAccountGroup.getCommerceAccountGroupId())));
        }
        return accountGroups;
    }
}

