/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceCountryService;
import com.liferay.commerce.service.CommerceRegionLocalService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountAddressResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountAddressResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-address.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountAddressResource.class})
public class AccountAddressResourceImpl
extends BaseAccountAddressResourceImpl {
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceCountryService _commerceCountryService;
    @Reference
    private CommerceRegionLocalService _commerceRegionLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Page<AccountAddress> getAccountByExternalReferenceCodeAccountAddressesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        return this._getAccountAddressesPage(commerceAccount, pagination);
    }

    @Override
    public Page<AccountAddress> getAccountIdAccountAddressesPage(Long id, Pagination pagination) throws Exception {
        return this._getAccountAddressesPage(this._commerceAccountService.getCommerceAccount(id.longValue()), pagination);
    }

    @Override
    public AccountAddress postAccountByExternalReferenceCodeAccountAddress(String externalReferenceCode, AccountAddress accountAddress) throws Exception {
        CommerceAccount commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceAccount == null) {
            throw new NoSuchAccountException("Unable to find Account with externalReferenceCode: " + externalReferenceCode);
        }
        return this._addAccountAddress(commerceAccount, accountAddress);
    }

    @Override
    public AccountAddress postAccountIdAccountAddress(Long id, AccountAddress accountAddress) throws Exception {
        return this._addAccountAddress(this._commerceAccountService.getCommerceAccount(id.longValue()), accountAddress);
    }

    private AccountAddress _addAccountAddress(CommerceAccount commerceAccount, AccountAddress accountAddress) throws Exception {
        CommerceCountry commerceCountry = this._commerceCountryService.getCommerceCountry(commerceAccount.getCompanyId(), accountAddress.getCountryISOCode());
        CommerceAddress commerceAddress = this._commerceAddressService.addCommerceAddress(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), accountAddress.getName(), accountAddress.getDescription(), accountAddress.getStreet1(), accountAddress.getStreet2(), accountAddress.getStreet3(), accountAddress.getCity(), accountAddress.getZip(), this._getCommerceRegionId(commerceCountry, accountAddress), commerceCountry.getCommerceCountryId(), accountAddress.getPhoneNumber(), GetterUtil.get((Object)accountAddress.getDefaultBilling(), (boolean)false), GetterUtil.get((Object)accountAddress.getDefaultShipping(), (boolean)false), this._serviceContextHelper.getServiceContext());
        DTOConverter accountAddressDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAddress.class.getName());
        return (AccountAddress)accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAddress.getCommerceAddressId()));
    }

    private Page<AccountAddress> _getAccountAddressesPage(CommerceAccount commerceAccount, Pagination pagination) throws Exception {
        List commerceAddresses = this._commerceAddressService.getCommerceAddresses(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceAddressService.getCommerceAddressesCount(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId());
        return Page.of(this._toAccountAddresses(commerceAddresses), (Pagination)pagination, (long)totalItems);
    }

    private long _getCommerceRegionId(CommerceCountry commerceCountry, AccountAddress accountAddress) throws PortalException {
        if (Validator.isNull((String)accountAddress.getRegionISOCode()) || commerceCountry == null) {
            return 0L;
        }
        CommerceRegion commerceRegion = this._commerceRegionLocalService.getCommerceRegion(commerceCountry.getCommerceCountryId(), accountAddress.getRegionISOCode());
        return commerceRegion.getCommerceRegionId();
    }

    private List<AccountAddress> _toAccountAddresses(List<CommerceAddress> commerceAddresses) throws Exception {
        ArrayList<AccountAddress> accountAddresses = new ArrayList<AccountAddress>();
        DTOConverter accountAddressDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAddress.class.getName());
        for (CommerceAddress commerceAddress : commerceAddresses) {
            accountAddresses.add((AccountAddress)accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceAddress.getCommerceAddressId())));
        }
        return accountAddresses;
    }
}

