/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountOrganizationRel;
import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.account.model.CommerceAccount"}, service={AccountDTOConverter.class, DTOConverter.class})
public class AccountDTOConverter
implements DTOConverter {
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public Account toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAccount commerceAccount = this._commerceAccountService.getCommerceAccount(dtoConverterContext.getResourcePrimKey());
        final ExpandoBridge expandoBridge = commerceAccount.getExpandoBridge();
        return new Account(){
            {
                this.addresses = AccountDTOConverter.this._getAddresses(commerceAccount, dtoConverterContext);
                this.customFields = expandoBridge.getAttributes();
                this.emailAddresses = new String[]{commerceAccount.getEmail()};
                this.externalReferenceCode = commerceAccount.getExternalReferenceCode();
                this.id = commerceAccount.getCommerceAccountId();
                this.logoId = commerceAccount.getLogoId();
                this.name = commerceAccount.getName();
                this.organizations = AccountDTOConverter.this._getOrganizations(commerceAccount, dtoConverterContext);
                this.root = commerceAccount.isRoot();
                this.taxId = commerceAccount.getTaxId();
                this.type = commerceAccount.getType();
                this.users = AccountDTOConverter.this._getUsers(commerceAccount, dtoConverterContext);
            }
        };
    }

    private AccountAddress[] _getAddresses(CommerceAccount commerceAccount, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<AccountAddress> accountAddresses = new ArrayList<AccountAddress>();
        DTOConverter accountAddressDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAddress.class.getName());
        List commerceAddresses = this._commerceAddressService.getCommerceAddresses(commerceAccount.getModelClassName(), commerceAccount.getCommerceAccountId(), -1, -1, null);
        for (CommerceAddress commerceAddress : commerceAddresses) {
            accountAddresses.add((AccountAddress)accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), commerceAddress.getCommerceAddressId())));
        }
        Stream stream = accountAddresses.stream();
        return (AccountAddress[])stream.toArray(AccountAddress[]::new);
    }

    private AccountOrganization[] _getOrganizations(CommerceAccount commerceAccount, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<AccountOrganization> accountOrganizations = new ArrayList<AccountOrganization>();
        DTOConverter accountOrganizationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccountOrganizationRel.class.getName());
        for (CommerceAccountOrganizationRel commerceAccountOrganizationRel : commerceAccount.getCommerceAccountOrganizationRels()) {
            accountOrganizations.add((AccountOrganization)accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), (Object)commerceAccountOrganizationRel.getPrimaryKey())));
        }
        Stream stream = accountOrganizations.stream();
        return (AccountOrganization[])stream.toArray(AccountOrganization[]::new);
    }

    private AccountMember[] _getUsers(CommerceAccount commerceAccount, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<AccountMember> accountMembers = new ArrayList<AccountMember>();
        DTOConverter accountMemberDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceAccountUserRel.class.getName());
        for (CommerceAccountUserRel commerceAccountUserRel : commerceAccount.getCommerceAccountUserRels()) {
            accountMembers.add((AccountMember)accountMemberDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), (Object)commerceAccountUserRel.getPrimaryKey())));
        }
        Stream stream = accountMembers.stream();
        return (AccountMember[])stream.toArray(AccountMember[]::new);
    }
}

