/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.service.impl;

import com.liferay.commerce.user.service.base.CommerceUserLocalServiceBaseImpl;
import com.liferay.commerce.user.util.CommerceRoleRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommerceUserLocalServiceImpl
extends CommerceUserLocalServiceBaseImpl {
    @ServiceReference(type=CommerceRoleRegistry.class)
    protected CommerceRoleRegistry commerceRoleRegistry;

    public User updateActive(long userId, boolean active) throws PortalException {
        int status = 5;
        if (active) {
            status = 0;
        }
        return this.userLocalService.updateStatus(userId, status, new ServiceContext());
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException {
        return this.userLocalService.updatePassword(userId, password1, password2, passwordReset);
    }

    public User updatePasswordReset(long userId, boolean passwordReset) throws PortalException {
        return this.userLocalService.updatePasswordReset(userId, passwordReset);
    }

    public User updateReminderQuery(long userId, String question, String answer) throws PortalException {
        return this.userLocalService.updateReminderQuery(userId, question, answer);
    }

    public User updateUser(long userId, String screenName, String emailAddress, boolean portrait, byte[] portraitBytes, String languageId, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        return this.userLocalService.updateUser(userId, user.getPassword(), null, null, false, user.getReminderQueryQuestion(), user.getReminderQueryAnswer(), screenName, emailAddress, user.getFacebookId(), user.getOpenId(), portrait, portraitBytes, languageId, user.getTimeZoneId(), user.getGreeting(), user.getComments(), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, null, null, null, null, null, jobTitle, user.getGroupIds(), user.getOrganizationIds(), user.getRoleIds(), null, user.getUserGroupIds(), serviceContext);
    }

    public void updateUserRoles(long userId, long groupId, long[] roleIds) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        HashSet<Long> organizationRoleIds = new HashSet<Long>();
        HashSet<Long> regularRoleIds = new HashSet<Long>();
        List roles = this.commerceRoleRegistry.getRoles(user.getCompanyId());
        for (long roleId : roleIds) {
            Role role;
            if (roleId <= 0L || !roles.contains(role = this.roleLocalService.getRole(roleId))) continue;
            if (role.getType() == 3) {
                organizationRoleIds.add(role.getRoleId());
                continue;
            }
            if (role.getType() != 1) continue;
            regularRoleIds.add(role.getRoleId());
        }
        this.updateUserRoles(userId, regularRoleIds);
        if (groupId > 0L) {
            this.updateUserGroupRoles(userId, groupId, organizationRoleIds);
        }
    }

    protected void updateUserGroupRoles(long userId, long groupId, Set<Long> roleIds) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        if (!group.isOrganization()) {
            return;
        }
        List previousUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId, groupId);
        for (UserGroupRole userGroupRole : previousUserGroupRoles) {
            if (roleIds.contains(userGroupRole.getRoleId())) {
                roleIds.remove(userGroupRole.getRoleId());
                continue;
            }
            this.userGroupRoleLocalService.deleteUserGroupRole(userGroupRole);
        }
        if (roleIds.isEmpty()) {
            return;
        }
        this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, ArrayUtil.toLongArray(roleIds));
    }

    protected void updateUserRoles(long userId, Set<Long> roleIds) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        List previousUserRoles = user.getRoles();
        for (Role userRole : previousUserRoles) {
            if (roleIds.contains(userRole.getRoleId())) {
                roleIds.remove(userRole.getRoleId());
                continue;
            }
            this.roleLocalService.deleteUserRole(userId, userRole);
        }
        if (roleIds.isEmpty()) {
            return;
        }
        this.roleLocalService.setUserRoles(userId, ArrayUtil.toLongArray(roleIds));
    }
}

