/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.service.impl;

import com.liferay.commerce.user.service.base.CommerceUserServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;

public class CommerceUserServiceImpl
extends CommerceUserServiceBaseImpl {
    public User getUser(long userId) throws PortalException {
        this._checkUser(userId);
        return this.userLocalService.getUser(userId);
    }

    public User updateActive(long userId, boolean active) throws PortalException {
        this._checkUser(userId);
        return this.commerceUserLocalService.updateActive(userId, active);
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException {
        this._checkUser(userId);
        return this.commerceUserLocalService.updatePassword(userId, password1, password2, passwordReset);
    }

    public User updatePasswordReset(long userId, boolean passwordReset) throws PortalException {
        this._checkUser(userId);
        return this.commerceUserLocalService.updatePasswordReset(userId, passwordReset);
    }

    public User updateReminderQuery(long userId, String question, String answer) throws PortalException {
        this._checkUser(userId);
        return this.commerceUserLocalService.updateReminderQuery(userId, question, answer);
    }

    public User updateUser(long userId, String screenName, String emailAddress, boolean portrait, byte[] portraitBytes, String languageId, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, ServiceContext serviceContext) throws PortalException {
        this._checkUser(userId);
        return this.commerceUserLocalService.updateUser(userId, screenName, emailAddress, portrait, portraitBytes, languageId, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, serviceContext);
    }

    public void updateUserRoles(long userId, long groupId, long[] roleIds) throws PortalException {
        this._checkUser(userId);
        this.commerceUserLocalService.updateUserRoles(userId, groupId, roleIds);
    }

    private void _checkUser(long userId) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        for (long organizationId : user.getOrganizationIds()) {
            if (!OrganizationPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"MANAGE_USERS")) continue;
            return;
        }
        throw new PrincipalException();
    }
}

