/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.web.internal.portlet.action;

import com.liferay.commerce.user.segment.exception.CommerceUserSegmentEntryKeyException;
import com.liferay.commerce.user.segment.exception.CommerceUserSegmentEntrySystemException;
import com.liferay.commerce.user.segment.exception.NoSuchUserSegmentEntryException;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentEntry;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_commerce_user_segment_web_internal_portlet_CommerceUserSegmentPortlet", "mvc.command.name=editCommerceUserSegmentEntry"}, service={MVCActionCommand.class})
public class EditCommerceUserSegmentEntryMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditCommerceUserSegmentEntryMVCActionCommand.class);
    @Reference
    private CommerceUserSegmentEntryService _commerceUserSegmentEntryService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    protected void addCommerceUserSegmentEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String key = ParamUtil.getString((PortletRequest)actionRequest, (String)"key", (String)name);
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active", (boolean)true);
        double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommerceUserSegmentEntry.class.getName(), (PortletRequest)actionRequest);
        nameMap.put(this._portal.getLocale((PortletRequest)actionRequest), name);
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        jsonObject.put("redirectURL", redirect);
        try {
            this._commerceUserSegmentEntryService.addCommerceUserSegmentEntry(nameMap, key, active, false, priority, serviceContext);
        }
        catch (Exception e) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this._portal.getLocale((PortletRequest)actionRequest), ((Object)((Object)this)).getClass());
            if (e instanceof CommerceUserSegmentEntryKeyException) {
                jsonObject.put("error", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"key-is-already-used"));
            }
            _log.error((Object)e, (Throwable)e);
            jsonObject.put("error", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"an-unexpected-error-occurred"));
        }
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    protected void deleteCommerceUserSegmentEntries(ActionRequest actionRequest) throws PortalException {
        long[] deleteCommerceUserSegmentEntryIds = null;
        long commerceUserSegmentEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceUserSegmentEntryId");
        deleteCommerceUserSegmentEntryIds = commerceUserSegmentEntryId > 0L ? new long[]{commerceUserSegmentEntryId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteCommerceUserSegmentEntryIds"), (long)0L);
        for (long deleteCommerceUserSegmentEntryId : deleteCommerceUserSegmentEntryIds) {
            this._commerceUserSegmentEntryService.deleteCommerceUserSegmentEntry(deleteCommerceUserSegmentEntryId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add")) {
                this.addCommerceUserSegmentEntry(actionRequest, actionResponse);
            } else if (cmd.equals("update")) {
                this.updateCommerceUserSegmentEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteCommerceUserSegmentEntries(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof CommerceUserSegmentEntryKeyException || e instanceof CommerceUserSegmentEntrySystemException || e instanceof NoSuchUserSegmentEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
    }

    protected void updateCommerceUserSegmentEntry(ActionRequest actionRequest) throws Exception {
        long commerceUserSegmentEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceUserSegmentEntryId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        String key = ParamUtil.getString((PortletRequest)actionRequest, (String)"key");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active", (boolean)true);
        double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommerceUserSegmentEntry.class.getName(), (PortletRequest)actionRequest);
        this._commerceUserSegmentEntryService.updateCommerceUserSegmentEntry(commerceUserSegmentEntryId, nameMap, key, active, priority, serviceContext);
    }
}

