/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.internal.util;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentEntryLocalService;
import com.liferay.commerce.user.segment.util.CommerceUserSegmentHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceUserSegmentHelper.class})
public class CommerceUserSegmentHelperImpl
implements CommerceUserSegmentHelper {
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceUserSegmentEntryLocalService _commerceUserSegmentEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public long[] getCommerceUserSegmentIds(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceAccount commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(httpServletRequest);
        if (commerceAccount == null) {
            return new long[0];
        }
        User user = this._portal.getUser(httpServletRequest);
        if (user == null) {
            user = this._userLocalService.getDefaultUser(this._portal.getCompanyId(httpServletRequest));
        }
        return this._commerceUserSegmentEntryLocalService.getCommerceUserSegmentEntryIds(this._portal.getScopeGroupId(httpServletRequest), commerceAccount.getCommerceAccountId(), user.getUserId());
    }

    public long[] getCommerceUserSegmentIds(long groupId, long commerceAccountId, long userId) throws PortalException {
        return this._commerceUserSegmentEntryLocalService.getCommerceUserSegmentEntryIds(groupId, commerceAccountId, userId);
    }

    public long[] getUserIds(long groupId, long commerceAccountId, long[] commerceUserSegmentEntryIds, int start, int end) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        SearchContext searchContext = new SearchContext();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("commerceAccountId", commerceAccountId);
        attributes.put("commerceUserSegmentEntryIds", commerceUserSegmentEntryIds);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setStart(start);
        searchContext.setEnd(end);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        Hits hits = indexer.search(searchContext, new String[]{"entryClassPK"});
        List documents = hits.toList();
        Stream stream = documents.stream();
        LongStream longStream = stream.mapToLong(field -> GetterUtil.getLong((String)field.get("entryClassPK")));
        return longStream.toArray();
    }
}

