/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.internal.criterion;

import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.internal.criterion.BaseCommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.user.segment.criterion.type.key=organization", "commerce.user.segment.criterion.type.order:Integer=20"}, service={CommerceUserSegmentCriterionType.class})
public class OrganizationCommerceUserSegmentCriterionTypeImpl
extends BaseCommerceUserSegmentCriterionType {
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public String getKey() {
        return "organization";
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"organizations");
    }

    public String getPreview(CommerceUserSegmentCriterion commerceUserSegmentCriterion, int length) {
        String[] organizationIds;
        if (length <= 0) {
            return "";
        }
        ArrayList<String> organizationNames = new ArrayList<String>();
        for (String organizationId : organizationIds = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings())) {
            Organization organization = this._organizationLocalService.fetchOrganization(GetterUtil.getLong((String)organizationId));
            if (organization == null) continue;
            organizationNames.add(organization.getName());
        }
        String preview = StringUtil.merge(organizationNames, (String)", ");
        return StringUtil.shorten((String)preview, (int)length, (String)"...");
    }

    public void userPostProcessContextBooleanFilter(CommerceUserSegmentCriterion commerceUserSegmentCriterion, BooleanFilter contextBooleanFilter, SearchContext searchContext) {
        String[] organizationIds = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings());
        long organizationId = GetterUtil.getLong((Object)searchContext.getAttribute("organizationId"));
        BooleanFilter booleanFilter = new BooleanFilter();
        if (organizationId > 0L) {
            TermFilter organizationTermFilter = new TermFilter("organizationIds", String.valueOf(organizationId));
            TermFilter ancestorTermFilter = new TermFilter("ancestorOrganizationIds", String.valueOf(organizationId));
            booleanFilter.add((Filter)organizationTermFilter, BooleanClauseOccur.SHOULD);
            booleanFilter.add((Filter)ancestorTermFilter, BooleanClauseOccur.SHOULD);
        } else {
            BooleanFilter organizationBooleanFilter = new BooleanFilter();
            BooleanFilter ancestorBooleanFilter = new BooleanFilter();
            for (String curOrganizationId : organizationIds) {
                TermFilter organizationTermFilter = new TermFilter("organizationIds", String.valueOf(curOrganizationId));
                TermFilter ancestorTermFilter = new TermFilter("ancestorOrganizationIds", String.valueOf(curOrganizationId));
                organizationBooleanFilter.add((Filter)organizationTermFilter, BooleanClauseOccur.MUST);
                ancestorBooleanFilter.add((Filter)ancestorTermFilter, BooleanClauseOccur.MUST);
                booleanFilter.add((Filter)organizationBooleanFilter, BooleanClauseOccur.SHOULD);
                booleanFilter.add((Filter)ancestorBooleanFilter, BooleanClauseOccur.SHOULD);
            }
        }
        contextBooleanFilter.add((Filter)booleanFilter, BooleanClauseOccur.MUST);
    }

    @Override
    protected long[] getUserClassPKs(User user) throws PortalException {
        long[] organizationIds;
        ArrayList<Long> userClassPKsList = new ArrayList<Long>();
        for (long organizationId : organizationIds = user.getOrganizationIds()) {
            Organization organization = this._organizationLocalService.getOrganization(organizationId);
            long[] ancestorOrganizationIds = organization.getAncestorOrganizationIds();
            userClassPKsList.addAll(ListUtil.toList((long[])ancestorOrganizationIds));
            userClassPKsList.add(organizationId);
        }
        Stream stream = userClassPKsList.stream();
        LongStream longStream = stream.mapToLong(field -> field);
        return longStream.toArray();
    }
}

