/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.internal.criterion;

import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.internal.criterion.BaseCommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.filter.TermsSetFilterBuilder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.user.segment.criterion.type.key=role", "commerce.user.segment.criterion.type.order:Integer=40"}, service={CommerceUserSegmentCriterionType.class})
public class RoleCommerceUserSegmentCriterionTypeImpl
extends BaseCommerceUserSegmentCriterionType {
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public String getKey() {
        return "role";
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"roles");
    }

    public String getPreview(CommerceUserSegmentCriterion commerceUserSegmentCriterion, int length) {
        String[] roleIds;
        if (length <= 0) {
            return "";
        }
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleId : roleIds = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings())) {
            Role role = this._roleLocalService.fetchRole(GetterUtil.getLong((String)roleId));
            if (role == null) continue;
            roleNames.add(role.getName());
        }
        String preview = StringUtil.merge(roleNames, (String)", ");
        return StringUtil.shorten((String)preview, (int)length, (String)"...");
    }

    @Override
    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws PortalException {
        User user = this.userLocalService.getUser(searchContext.getUserId());
        long organizationId = GetterUtil.getLong((Object)searchContext.getAttribute("organizationId"));
        long[] classPKs = this.getUserClassPKs(user, organizationId, searchContext.getGroupIds());
        TermsSetFilterBuilder termsSetFilterBuilder = this.filterBuilders.termsSetFilterBuilder();
        termsSetFilterBuilder.setFieldName(this.getIndexerFieldName());
        termsSetFilterBuilder.setMinimumShouldMatchField(this.getIndexerFieldName() + "_required_matches");
        ArrayList<String> values = new ArrayList<String>(classPKs.length);
        for (long classPK : classPKs) {
            values.add(String.valueOf(classPK));
        }
        termsSetFilterBuilder.setValues(values);
        TermFilter termFilter = new TermFilter(this.getIndexerFieldName() + "_required_matches", "0");
        BooleanFilter fieldBooleanFilter = new BooleanFilter();
        fieldBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
        fieldBooleanFilter.add((Filter)termsSetFilterBuilder.build(), BooleanClauseOccur.SHOULD);
        contextBooleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
    }

    public void userPostProcessContextBooleanFilter(CommerceUserSegmentCriterion commerceUserSegmentCriterion, BooleanFilter contextBooleanFilter, SearchContext searchContext) throws PortalException {
        long organizationId = GetterUtil.getLong((Object)searchContext.getAttribute("organizationId"));
        long[] roleIds = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings(), (long)0L);
        BooleanFilter booleanFilter = new BooleanFilter();
        for (long roleId : roleIds) {
            Role role = this._roleLocalService.getRole(roleId);
            TermFilter roleFilter = organizationId > 0L && role.getType() == 3 ? new TermFilter("organization_" + organizationId + "_roleIds", String.valueOf(roleId)) : new TermFilter("roleIds", String.valueOf(roleId));
            booleanFilter.add((Filter)roleFilter, BooleanClauseOccur.MUST);
        }
        contextBooleanFilter.add((Filter)booleanFilter, BooleanClauseOccur.MUST);
    }

    @Override
    protected long[] getUserClassPKs(User user) throws PortalException {
        return null;
    }

    protected long[] getUserClassPKs(User user, long organizationId, long ... groupIds) throws PortalException {
        if (user.isDefaultUser()) {
            Role role = this._roleLocalService.getRole(user.getCompanyId(), "Guest");
            return new long[]{role.getRoleId()};
        }
        ArrayList userGroupRoles = new ArrayList();
        Organization organization = this._organizationLocalService.fetchOrganization(organizationId);
        if (organization != null) {
            userGroupRoles.addAll(this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId(), organization.getGroupId()));
        }
        for (long groupId : groupIds) {
            userGroupRoles.addAll(this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId(), groupId));
        }
        Stream stream = userGroupRoles.stream();
        LongStream longStream = stream.mapToLong(UserGroupRoleModel::getRoleId);
        long[] roleIds = longStream.toArray();
        return ArrayUtil.append((long[][])new long[][]{roleIds, user.getRoleIds()});
    }
}

