/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.internal.criterion;

import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentCriterionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.filter.TermsSetFilterBuilder;
import java.util.ArrayList;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceUserSegmentCriterionType
implements CommerceUserSegmentCriterionType {
    @Reference
    protected CommerceUserSegmentCriterionLocalService commerceUserSegmentCriterionLocalService;
    @Reference
    protected FilterBuilders filterBuilders;
    @Reference
    protected UserLocalService userLocalService;

    public void contributeToDocument(CommerceUserSegmentCriterion commerceUserSegmentCriterion, Document document) {
        if (commerceUserSegmentCriterion == null) {
            return;
        }
        if (Validator.isNull((String)commerceUserSegmentCriterion.getTypeSettings())) {
            return;
        }
        long[] classPKs = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings(), (long)0L);
        document.addKeyword(this.getIndexerFieldName(), classPKs);
        document.addKeyword(this.getIndexerFieldName() + "_required_matches", classPKs.length);
    }

    public void contributeToDocument(Document document) {
        document.addKeyword(this.getIndexerFieldName(), new long[0]);
        document.addKeyword(this.getIndexerFieldName() + "_required_matches", 0);
    }

    public boolean isSatisfied(long commerceUserSegmentCriterionId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceUserSegmentCriterion commerceUserSegmentCriterion = this.commerceUserSegmentCriterionLocalService.getCommerceUserSegmentCriterion(commerceUserSegmentCriterionId);
        long[] classPKs = StringUtil.split((String)commerceUserSegmentCriterion.getTypeSettings(), (long)0L);
        return ArrayUtil.containsAll((long[])classPKs, (long[])this.getUserClassPKs(user));
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws PortalException {
        User user = this.userLocalService.getUser(searchContext.getUserId());
        long[] classPKs = this.getUserClassPKs(user);
        TermsSetFilterBuilder termsSetFilterBuilder = this.filterBuilders.termsSetFilterBuilder();
        termsSetFilterBuilder.setFieldName(this.getIndexerFieldName());
        termsSetFilterBuilder.setMinimumShouldMatchField(this.getIndexerFieldName() + "_required_matches");
        ArrayList<String> values = new ArrayList<String>(classPKs.length);
        for (long classPK : classPKs) {
            values.add(String.valueOf(classPK));
        }
        termsSetFilterBuilder.setValues(values);
        TermFilter existFilter = new TermFilter(this.getIndexerFieldName() + "_required_matches", "0");
        BooleanFilter fieldBooleanFilter = new BooleanFilter();
        fieldBooleanFilter.add((Filter)existFilter, BooleanClauseOccur.SHOULD);
        fieldBooleanFilter.add((Filter)termsSetFilterBuilder.build(), BooleanClauseOccur.SHOULD);
        contextBooleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
    }

    protected String getIndexerFieldName() {
        return "criterionType_" + this.getKey();
    }

    protected abstract long[] getUserClassPKs(User var1) throws PortalException;
}

