/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.internal.search;

import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionTypeRegistry;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentCriterionLocalService;
import com.liferay.commerce.user.segment.util.comparator.CommerceUserSegmentCriterionPriorityComparator;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.search.BaseIndexerPostProcessor;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={IndexerPostProcessor.class})
public class UserIndexerPostProcessor
extends BaseIndexerPostProcessor {
    @Reference
    private CommerceUserSegmentCriterionLocalService _commerceUserSegmentCriterionLocalService;
    @Reference
    private CommerceUserSegmentCriterionTypeRegistry _commerceUserSegmentCriterionTypeRegistry;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public void postProcessContextBooleanFilter(BooleanFilter booleanFilter, SearchContext searchContext) throws Exception {
        long[] commerceUserSegmentEntryIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceUserSegmentEntryIds"), null);
        if (commerceUserSegmentEntryIds == null) {
            return;
        }
        for (long commerceUserSegmentEntryId : commerceUserSegmentEntryIds) {
            List commerceUserSegmentCriteria = this._commerceUserSegmentCriterionLocalService.getCommerceUserSegmentCriteria(commerceUserSegmentEntryId, -1, -1, (OrderByComparator)new CommerceUserSegmentCriterionPriorityComparator(true));
            for (CommerceUserSegmentCriterion commerceUserSegmentCriterion : commerceUserSegmentCriteria) {
                CommerceUserSegmentCriterionType commerceUserSegmentCriterionType = this._commerceUserSegmentCriterionTypeRegistry.getCommerceUserSegmentCriterionType(commerceUserSegmentCriterion.getType());
                commerceUserSegmentCriterionType.userPostProcessContextBooleanFilter(commerceUserSegmentCriterion, booleanFilter, searchContext);
            }
        }
    }

    public void postProcessDocument(Document document, Object obj) throws Exception {
        User user = (User)obj;
        List organizations = this._organizationLocalService.getUserOrganizations(user.getUserId());
        for (Organization organization : organizations) {
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId(), organization.getGroupId());
            Stream stream = userGroupRoles.stream();
            long[] roleIds = stream.mapToLong(UserGroupRoleModel::getRoleId).toArray();
            document.addNumber("organization_" + organization.getOrganizationId() + "_roleIds", roleIds);
        }
    }
}

