/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.user.segment.internal.search;

import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionType;
import com.liferay.commerce.user.segment.criterion.CommerceUserSegmentCriterionTypeRegistry;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentCriterion;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentEntry;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentCriterionLocalService;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentEntryLocalService;
import com.liferay.commerce.user.segment.util.comparator.CommerceUserSegmentCriterionPriorityComparator;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceUserSegmentEntryIndexer
extends BaseIndexer<CommerceUserSegmentEntry> {
    public static final String CLASS_NAME = CommerceUserSegmentEntry.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CommerceUserSegmentEntryIndexer.class);
    @Reference
    private CommerceUserSegmentCriterionLocalService _commerceUserSegmentCriterionLocalService;
    @Reference
    private CommerceUserSegmentCriterionTypeRegistry _commerceUserSegmentCriterionTypeRegistry;
    @Reference
    private CommerceUserSegmentEntryLocalService _commerceUserSegmentEntryLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommerceUserSegmentEntryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "name", "scopeGroupId", "uid"});
        this.setFilterSearch(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        boolean criterionType = GetterUtil.getBoolean((Object)searchContext.getAttribute("criterionType"));
        boolean active = GetterUtil.getBoolean((Object)searchContext.getAttribute("active"));
        if (active) {
            TermFilter termFilter = new TermFilter("active", Boolean.TRUE.toString());
            contextBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.MUST);
        }
        if (criterionType) {
            List commerceUserSegmentCriterionTypes = this._commerceUserSegmentCriterionTypeRegistry.getCommerceUserSegmentCriterionTypes();
            for (CommerceUserSegmentCriterionType commerceUserSegmentCriterionType : commerceUserSegmentCriterionTypes) {
                commerceUserSegmentCriterionType.postProcessContextBooleanFilter(contextBooleanFilter, searchContext);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CommerceUserSegmentEntry commerceUserSegmentEntry) throws Exception {
        this.deleteDocument(commerceUserSegmentEntry.getCompanyId(), commerceUserSegmentEntry.getCommerceUserSegmentEntryId());
    }

    protected Document doGetDocument(CommerceUserSegmentEntry commerceUserSegmentEntry) throws Exception {
        String[] languageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing user segment " + commerceUserSegmentEntry));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceUserSegmentEntry);
        document.addNumber("entryClassPK", commerceUserSegmentEntry.getCommerceUserSegmentEntryId());
        document.addText("userName", commerceUserSegmentEntry.getUserName());
        document.addNumberSortable("priority", Double.valueOf(commerceUserSegmentEntry.getPriority()));
        document.addKeyword("active", commerceUserSegmentEntry.isActive());
        String commerceUserSegmentEntryLanguageId = LocalizationUtil.getDefaultLanguageId((String)commerceUserSegmentEntry.getName());
        for (String languageId : languageIds = LocalizationUtil.getAvailableLanguageIds((String)commerceUserSegmentEntry.getName())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)languageId), commerceUserSegmentEntry.getName(languageId));
            if (!languageId.equals(commerceUserSegmentEntryLanguageId)) continue;
            document.addText("name", commerceUserSegmentEntry.getName(languageId));
            document.addText("defaultLanguageId", languageId);
        }
        try {
            List commerceUserSegmentCriterionTypes = this._commerceUserSegmentCriterionTypeRegistry.getCommerceUserSegmentCriterionTypes();
            for (CommerceUserSegmentCriterionType commerceUserSegmentCriterionType : commerceUserSegmentCriterionTypes) {
                commerceUserSegmentCriterionType.contributeToDocument(document);
            }
            List commerceUserSegmentCriteria = this._commerceUserSegmentCriterionLocalService.getCommerceUserSegmentCriteria(commerceUserSegmentEntry.getCommerceUserSegmentEntryId(), -1, -1, (OrderByComparator)new CommerceUserSegmentCriterionPriorityComparator(true));
            for (CommerceUserSegmentCriterion commerceUserSegmentCriterion : commerceUserSegmentCriteria) {
                CommerceUserSegmentCriterionType commerceUserSegmentCriterionType = this._commerceUserSegmentCriterionTypeRegistry.getCommerceUserSegmentCriterionType(commerceUserSegmentCriterion.getType());
                commerceUserSegmentCriterionType.contributeToDocument(commerceUserSegmentCriterion, document);
            }
        }
        catch (Exception ex) {
            _log.error((Object)("Error indexing Document" + commerceUserSegmentEntry), (Throwable)ex);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceUserSegmentEntry + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceUserSegmentEntry commerceUserSegmentEntry) throws Exception {
        Document document = this.getDocument(commerceUserSegmentEntry);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceUserSegmentEntry.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        CommerceUserSegmentEntry commerceUserSegmentEntry = this._commerceUserSegmentEntryLocalService.getCommerceUserSegmentEntry(classPK);
        this.doReindex(commerceUserSegmentEntry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceUserSegmentEntries(companyId);
    }

    protected void reindexCommerceUserSegmentEntries(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceUserSegmentEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<CommerceUserSegmentEntry>(){

            public void performAction(CommerceUserSegmentEntry commerceUserSegmentEntry) {
                block2: {
                    try {
                        Document document = CommerceUserSegmentEntryIndexer.this.getDocument(commerceUserSegmentEntry);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index commerce user segment " + commerceUserSegmentEntry.getCommerceUserSegmentEntryId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

