/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.theme.speedwell.site.initializer.internal;

import com.liferay.commerce.account.util.CommerceAccountRoleHelper;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.initializer.util.AssetCategoriesImporter;
import com.liferay.commerce.initializer.util.BlogsImporter;
import com.liferay.commerce.initializer.util.CPDefinitionsImporter;
import com.liferay.commerce.initializer.util.CPOptionCategoriesImporter;
import com.liferay.commerce.initializer.util.CPOptionsImporter;
import com.liferay.commerce.initializer.util.CPSpecificationOptionsImporter;
import com.liferay.commerce.initializer.util.CommerceAccountsImporter;
import com.liferay.commerce.initializer.util.CommerceDiscountsImporter;
import com.liferay.commerce.initializer.util.CommerceInventoryWarehousesImporter;
import com.liferay.commerce.initializer.util.CommercePriceEntriesImporter;
import com.liferay.commerce.initializer.util.CommercePriceListsImporter;
import com.liferay.commerce.initializer.util.CommerceUsersImporter;
import com.liferay.commerce.initializer.util.DDMFormImporter;
import com.liferay.commerce.initializer.util.DLImporter;
import com.liferay.commerce.initializer.util.JournalArticleImporter;
import com.liferay.commerce.initializer.util.KBArticleImporter;
import com.liferay.commerce.initializer.util.OrganizationImporter;
import com.liferay.commerce.initializer.util.PortletSettingsImporter;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.media.CommerceCatalogDefaultImage;
import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.importer.CPFileImporter;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPDefinitionLinkLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceCountryLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalService;
import com.liferay.commerce.theme.speedwell.site.initializer.internal.SpeedwellLayoutsInitializer;
import com.liferay.commerce.theme.speedwell.site.initializer.internal.dependencies.resolver.SpeedwellDependencyResolver;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"site.initializer.key=speedwell-initializer"}, service={SiteInitializer.class})
public class SpeedwellSiteInitializer
implements SiteInitializer {
    public static final String KEY = "speedwell-initializer";
    private static final String _SPEEDWELL_THEME_ID = "speedwell_WAR_speedwelltheme";
    private static final Log _log = LogFactoryUtil.getLog(SpeedwellSiteInitializer.class);
    @Reference
    private AssetCategoriesImporter _assetCategoriesImporter;
    @Reference
    private BlogsImporter _blogsImporter;
    @Reference
    private CommerceAccountRoleHelper _commerceAccountRoleHelper;
    @Reference
    private CommerceAccountsImporter _commerceAccountsImporter;
    @Reference
    private CommerceCatalogDefaultImage _commerceCatalogDefaultImage;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCountryLocalService _commerceCountryLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceDiscountsImporter _commerceDiscountsImporter;
    @Reference
    private CommerceInventoryWarehousesImporter _commerceInventoryWarehousesImporter;
    @Reference
    private CommercePriceEntriesImporter _commercePriceEntriesImporter;
    @Reference
    private CommercePriceListsImporter _commercePriceListsImporter;
    @Reference
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @Reference
    private CommerceShippingFixedOptionLocalService _commerceShippingFixedOptionLocalService;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private CommerceUsersImporter _commerceUsersImporter;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPDefinitionLinkLocalService _cpDefinitionLinkLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    private Map<String, CPDefinition> _cpDefinitions;
    @Reference
    private CPDefinitionsImporter _cpDefinitionsImporter;
    @Reference
    private CPFileImporter _cpFileImporter;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private CPOptionCategoriesImporter _cpOptionCategoriesImporter;
    @Reference
    private CPOptionsImporter _cpOptionsImporter;
    @Reference
    private CPSpecificationOptionsImporter _cpSpecificationOptionsImporter;
    @Reference
    private DDMFormImporter _ddmFormImporter;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLImporter _dlImporter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleImporter _journalArticleImporter;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private KBArticleImporter _kbArticleImporter;
    @Reference
    private OrganizationImporter _organizationImporter;
    @Reference
    private PortletSettingsImporter _portletSettingsImporter;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference(target="(osgi.web.symbolicname=com.liferay.commerce.theme.speedwell.site.initializer)")
    private ServletContext _servletContext;
    @Reference
    private SettingsFactory _settingsFactory;
    @Reference
    private SpeedwellDependencyResolver _speedwellDependencyResolver;
    @Reference
    private SpeedwellLayoutsInitializer _speedwellLayoutsInitializer;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"speedwell-description");
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"speedwell");
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void init() {
        this._cpDefinitions = new HashMap<String, CPDefinition>();
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            ServiceContext serviceContext = this.getServiceContext(groupId);
            this._cpFileImporter.updateLookAndFeel(_SPEEDWELL_THEME_ID, false, serviceContext);
            this.updateLogo(serviceContext);
            this.createRoles(serviceContext);
            CommerceCatalog commerceCatalog = this.createCatalog(serviceContext);
            long catalogGroupId = commerceCatalog.getGroupId();
            CommerceChannel commerceChannel = this.createChannel(commerceCatalog, serviceContext);
            this.configureB2CSite(commerceChannel.getGroupId(), serviceContext);
            this._speedwellLayoutsInitializer.initialize(serviceContext);
            this._importAssetCategories(serviceContext);
            this._importBlogsEntries(serviceContext);
            this._importCommerceDiscounts(serviceContext);
            this._importCPOptionCategories(catalogGroupId, serviceContext);
            this._importCPSpecificationOptions(catalogGroupId, serviceContext);
            List<CommerceInventoryWarehouse> commerceInventoryWarehouses = this._importCommerceInventoryWarehouses(serviceContext);
            this._importCPOptions(catalogGroupId, serviceContext);
            this._importCommerceOrganizations(serviceContext);
            this._importCommerceAccounts(serviceContext);
            List<CPDefinition> cpDefinitions = this._importCPDefinitions(catalogGroupId, commerceChannel.getCommerceChannelId(), commerceInventoryWarehouses, serviceContext);
            this._importRelatedProducts(cpDefinitions, serviceContext);
            this._importCommercePriceLists(catalogGroupId, serviceContext);
            this._importCommercePriceEntries(catalogGroupId, serviceContext);
            this._importCommerceUsers(serviceContext);
            this._importDDMForms(serviceContext);
            this._importDLFileEntries(serviceContext);
            this._importJournalArticles(serviceContext);
            this._importKBArticles(serviceContext);
            this._importThemePortletSettings(serviceContext);
            this._importPortletSettings(serviceContext);
            this.fixDLFileEntryPermissions(groupId);
            this.setCommerceShippingMethod(commerceChannel.getGroupId(), "fixed", serviceContext);
            int catalogCPDefinitionsCount = this._cpDefinitionLocalService.getCPDefinitionsCount(catalogGroupId, -1);
            if (catalogCPDefinitionsCount > 0) {
                this.setDefaultCatalogImage(catalogGroupId, serviceContext);
            } else {
                this._commerceCatalogLocalService.deleteCommerceCatalog(commerceCatalog);
            }
            this.setThemeSettings(serviceContext);
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new InitializationException((Throwable)e);
        }
    }

    public boolean isActive(long companyId) {
        Theme theme = this._themeLocalService.fetchTheme(companyId, _SPEEDWELL_THEME_ID);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"speedwell_WAR_speedwelltheme is not registered");
            }
            return false;
        }
        return true;
    }

    @Activate
    protected void activate() {
        this.init();
    }

    protected void configureB2CSite(long groupId, ServiceContext serviceContext) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        group.setType(1);
        group.setManualMembership(true);
        group.setMembershipRestriction(0);
        this._groupLocalService.updateGroup(group);
        this._commerceCountryLocalService.importDefaultCountries(serviceContext);
        this._commerceCurrencyLocalService.importDefaultValues(serviceContext);
        this._cpMeasurementUnitLocalService.importDefaultValues(serviceContext);
        this._commerceAccountRoleHelper.checkCommerceAccountRoles(serviceContext);
        Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.account"));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.setValue("commerceSiteType", String.valueOf(0));
        modifiableSettings.store();
    }

    protected CommerceCatalog createCatalog(ServiceContext serviceContext) throws Exception {
        Group group = serviceContext.getScopeGroup();
        CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(serviceContext.getCompanyId());
        return this._commerceCatalogLocalService.addCommerceCatalog(group.getName(serviceContext.getLanguageId()), commerceCurrency.getCode(), serviceContext.getLanguageId(), "", serviceContext);
    }

    protected CommerceChannel createChannel(CommerceCatalog commerceCatalog, ServiceContext serviceContext) throws Exception {
        Group group = serviceContext.getScopeGroup();
        return this._commerceChannelLocalService.addCommerceChannel(group.getGroupId(), group.getName(serviceContext.getLanguageId()) + " Portal", "site", null, commerceCatalog.getCommerceCurrencyCode(), "", serviceContext);
    }

    protected void createRoles(ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("roles.json");
        this._cpFileImporter.createRoles(jsonArray, serviceContext);
        this.updateUserRole(serviceContext);
    }

    @Deactivate
    protected void deactivate() {
        this._cpDefinitions = null;
    }

    protected void fixDLFileEntryPermissions(long groupId) throws PortalException {
        List dlFileEntries = this._dlFileEntryLocalService.getFileEntries(groupId, 0L);
        if (dlFileEntries.isEmpty()) {
            return;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        long companyId = group.getCompanyId();
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            Role role = this._roleLocalService.getRole(companyId, "Guest");
            this._resourcePermissionLocalService.setResourcePermissions(companyId, dlFileEntry.getModelClassName(), 4, String.valueOf(dlFileEntry.getPrimaryKey()), role.getRoleId(), new String[]{"VIEW"});
        }
    }

    protected CPDefinition getCPDefinitionByName(String name) {
        return this._cpDefinitions.get(name);
    }

    protected ServiceContext getServiceContext(long groupId) throws PortalException {
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        Group group = this._groupLocalService.getGroup(groupId);
        Locale locale = LocaleUtil.getSiteDefault();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCompanyId(group.getCompanyId());
        serviceContext.setLanguageId(LanguageUtil.getLanguageId((Locale)locale));
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setTimeZone(user.getTimeZone());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    protected void setCommerceShippingMethod(long groupId, String shippingMethod, ServiceContext serviceContext) throws PortalException {
        Locale locale = serviceContext.getLocale();
        CommerceShippingEngine commerceShippingEngine = this._commerceShippingEngineRegistry.getCommerceShippingEngine(shippingMethod);
        Map<Locale, String> nameMap = Collections.singletonMap(locale, commerceShippingEngine.getName(locale));
        Map<Locale, String> descriptionMap = Collections.singletonMap(locale, commerceShippingEngine.getDescription(locale));
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.addCommerceShippingMethod(serviceContext.getUserId(), groupId, nameMap, descriptionMap, null, shippingMethod, 0.0, true);
        this.setCommerceShippingOption(commerceShippingMethod, "Standard Delivery", "", BigDecimal.valueOf(15L), serviceContext);
        this.setCommerceShippingOption(commerceShippingMethod, "Expedited Delivery", "", BigDecimal.valueOf(25L), serviceContext);
    }

    protected void setCommerceShippingOption(CommerceShippingMethod commerceShippingMethod, String name, String description, BigDecimal price, ServiceContext serviceContext) throws PortalException {
        Map<Locale, String> nameMap = Collections.singletonMap(serviceContext.getLocale(), name);
        Map<Locale, String> descriptionMap = Collections.singletonMap(serviceContext.getLocale(), description);
        this._commerceShippingFixedOptionLocalService.addCommerceShippingFixedOption(serviceContext.getUserId(), commerceShippingMethod.getGroupId(), commerceShippingMethod.getCommerceShippingMethodId(), nameMap, descriptionMap, price, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultCatalogImage(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        ClassLoader classLoader = this._speedwellDependencyResolver.getImageClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this._speedwellDependencyResolver.getImageDependencyPath() + "Speedwell_ProductImage_Default.png");
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            String mimeType = MimeTypesUtil.getContentType((File)file);
            FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)catalogGroupId, (long)serviceContext.getUserId(), (String)SpeedwellSiteInitializer.class.getName(), (String)file.getName(), (File)file, (String)mimeType);
            this._commerceCatalogDefaultImage.updateDefaultCatalogFileEntryId(catalogGroupId, fileEntry.getFileEntryId());
        }
        finally {
            if (file != null) {
                FileUtil.delete((File)file);
            }
        }
    }

    protected void setThemeSettings(ServiceContext serviceContext) throws Exception {
        JSONObject themeSettingsJSONObject = this._getJSONObject("theme-settings.json");
        Iterator iterator = themeSettingsJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = themeSettingsJSONObject.getString(key);
            this.updateThemeSetting(key, value, serviceContext);
        }
    }

    protected void updateLogo(ServiceContext serviceContext) throws Exception {
        ClassLoader classLoader = this._speedwellDependencyResolver.getImageClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this._speedwellDependencyResolver.getImageDependencyPath() + "Speedwell_Logo.png");
        File file = FileUtil.createTempFile((InputStream)inputStream);
        this._cpFileImporter.updateLogo(file, false, true, serviceContext);
        this._cpFileImporter.updateLogo(file, true, true, serviceContext);
    }

    protected void updateThemeSetting(String key, String value, ServiceContext serviceContext) {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), _SPEEDWELL_THEME_ID);
        if (theme == null) {
            return;
        }
        Map configurableSettings = theme.getConfigurableSettings();
        ThemeSetting themeSetting = (ThemeSetting)configurableSettings.get(key);
        themeSetting.setValue(value);
    }

    protected void updateUserRole(ServiceContext serviceContext) throws PortalException {
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), "User");
        this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), "com.liferay.commerce.product", 3, String.valueOf(0L), role.getRoleId(), "VIEW_PRICE");
    }

    private long[] _getCProductIds(JSONArray jsonArray) {
        ArrayList<Long> cProductIdsList = new ArrayList<Long>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            CPDefinition cpDefinitionEntry = this.getCPDefinitionByName(jsonArray.getString(i));
            cProductIdsList.add(cpDefinitionEntry.getCProductId());
        }
        return ArrayUtil.toLongArray(cProductIdsList);
    }

    private JSONArray _getJSONArray(String name) throws Exception {
        return this._jsonFactory.createJSONArray(this._speedwellDependencyResolver.getJSON(name));
    }

    private JSONObject _getJSONObject(String name) throws Exception {
        return this._jsonFactory.createJSONObject(this._speedwellDependencyResolver.getJSON(name));
    }

    private void _importAssetCategories(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Asset Categories...");
        }
        Group group = serviceContext.getScopeGroup();
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        JSONArray jsonArray = this._getJSONArray("categories.json");
        this._assetCategoriesImporter.importAssetCategories(jsonArray, group.getName(serviceContext.getLocale()), this._speedwellDependencyResolver.getImageClassLoader(), this._speedwellDependencyResolver.getImageDependencyPath(), company.getGroupId(), serviceContext.getUserId(), true);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Asset Categories successfully imported");
        }
    }

    private void _importBlogsEntries(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Blogs Entries...");
        }
        JSONArray jsonArray = this._getJSONArray("blogs.json");
        this._blogsImporter.importBlogsEntries(jsonArray, this._speedwellDependencyResolver.getImageClassLoader(), this._speedwellDependencyResolver.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Blogs Entries successfully imported");
        }
    }

    private void _importCommerceAccounts(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Accounts...");
        }
        JSONArray jsonArray = this._getJSONArray("accounts.json");
        this._commerceAccountsImporter.importCommerceAccounts(jsonArray, this._speedwellDependencyResolver.getImageClassLoader(), this._speedwellDependencyResolver.getDependenciesPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Accounts successfully imported");
        }
    }

    private void _importCommerceDiscounts(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Discounts...");
        }
        JSONArray jsonArray = this._getJSONArray("discounts.json");
        this._commerceDiscountsImporter.importCommerceDiscounts(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Discounts successfully imported");
        }
    }

    private List<CommerceInventoryWarehouse> _importCommerceInventoryWarehouses(ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("warehouses.json");
        return this._commerceInventoryWarehousesImporter.importCommerceInventoryWarehouses(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _importCommerceOrganizations(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Organizations...");
        }
        JSONArray jsonArray = this._getJSONArray("organizations.json");
        this._organizationImporter.importOrganizations(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Organizations successfully imported");
        }
    }

    private void _importCommercePriceEntries(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Price Entries...");
        }
        JSONArray jsonArray = this._getJSONArray("price-entries.json");
        this._commercePriceEntriesImporter.importCommercePriceEntries(jsonArray, catalogGroupId, serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Price Entries successfully imported");
        }
    }

    private void _importCommercePriceLists(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Price Lists...");
        }
        JSONArray jsonArray = this._getJSONArray("price-lists.json");
        this._commercePriceListsImporter.importCommercePriceLists(catalogGroupId, jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Price Lists successfully imported");
        }
    }

    private void _importCommerceUsers(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Users...");
        }
        JSONArray jsonArray = this._getJSONArray("users.json");
        this._commerceUsersImporter.importCommerceUsers(jsonArray, this._speedwellDependencyResolver.getImageClassLoader(), this._speedwellDependencyResolver.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Users successfully imported");
        }
    }

    private List<CPDefinition> _importCPDefinitions(long catalogGroupId, long commerceChannelId, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, ServiceContext serviceContext) throws Exception {
        Group group = serviceContext.getScopeGroup();
        JSONArray jsonArray = this._getJSONArray("products.json");
        long[] commerceInventoryWarehouseIds = ListUtil.toLongArray(commerceInventoryWarehouses, (Accessor)CommerceInventoryWarehouse.COMMERCE_INVENTORY_WAREHOUSE_ID_ACCESSOR);
        return this._cpDefinitionsImporter.importCPDefinitions(jsonArray, group.getName(serviceContext.getLocale()), catalogGroupId, commerceChannelId, commerceInventoryWarehouseIds, this._speedwellDependencyResolver.getImageClassLoader(), this._speedwellDependencyResolver.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _importCPOptionCategories(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Product Option Categories...");
        }
        JSONArray jsonArray = this._getJSONArray("option-categories.json");
        this._cpOptionCategoriesImporter.importCPOptionCategories(jsonArray, catalogGroupId, serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Product Option Categories successfully imported");
        }
    }

    private List<CPOption> _importCPOptions(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("options.json");
        return this._cpOptionsImporter.importCPOptions(jsonArray, catalogGroupId, serviceContext.getUserId());
    }

    private void _importCPSpecificationOptions(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Product Specification Options...");
        }
        JSONArray jsonArray = this._getJSONArray("specification-options.json");
        this._cpSpecificationOptionsImporter.importCPSpecificationOptions(jsonArray, catalogGroupId, serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Product Specification Options successfully imported");
        }
    }

    private void _importDDMForms(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing DDM Forms...");
        }
        JSONArray jsonArray = this._getJSONArray("forms.json");
        this._ddmFormImporter.importDDMForms(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"DDM Forms successfully imported");
        }
    }

    private void _importDLFileEntries(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing DL File Entries...");
        }
        JSONArray jsonArray = this._getJSONArray("dl-file-entries.json");
        this._dlImporter.importDocuments(jsonArray, this._speedwellDependencyResolver.getDocumentsClassLoader(), this._speedwellDependencyResolver.getDocumentsDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"DL File Entries successfully imported");
        }
    }

    private void _importJournalArticles(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Journal Articles...");
        }
        JSONArray jsonArray = this._getJSONArray("journal-articles.json");
        this._journalArticleImporter.importJournalArticles(jsonArray, this._speedwellDependencyResolver.getDocumentsClassLoader(), this._speedwellDependencyResolver.getDependenciesPath() + "journal_articles/", serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Journal Articles successfully imported");
        }
    }

    private void _importKBArticles(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing KB Articles...");
        }
        JSONArray jsonArray = this._getJSONArray("kb-articles.json");
        this._kbArticleImporter.importKBArticles(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"KB Articles successfully imported");
        }
    }

    private void _importPortletSettings(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing portlet settings...");
        }
        JSONArray jsonArray = this._getJSONArray("portlet-settings.json");
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this._portletSettingsImporter.importPortletSettings(jsonArray, this._speedwellDependencyResolver.getDisplayTemplatesClassLoader(), this._speedwellDependencyResolver.getDisplayTemplatesDependencyPath(), serviceContext.getScopeGroupId(), company.getGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Portlet settings successfully imported");
        }
    }

    private void _importRelatedProducts(JSONArray jsonArray, ServiceContext serviceContext) throws Exception {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject productJSONObject = jsonArray.getJSONObject(i);
            JSONArray relatedProducts = productJSONObject.getJSONArray("RelatedProducts");
            if (relatedProducts == null) continue;
            String name = productJSONObject.getString("Name");
            CPDefinition cpDefinition = this.getCPDefinitionByName(name);
            this._cpDefinitionLinkLocalService.updateCPDefinitionLinkCProductIds(cpDefinition.getCPDefinitionId(), this._getCProductIds(relatedProducts), "related", serviceContext);
        }
    }

    private void _importRelatedProducts(List<CPDefinition> cpDefinitions, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Related Products...");
        }
        for (CPDefinition cpDefinition : cpDefinitions) {
            this._cpDefinitions.put(cpDefinition.getName(serviceContext.getLanguageId()), cpDefinition);
        }
        JSONArray jsonArray = this._getJSONArray("products.json");
        this._importRelatedProducts(jsonArray, serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Related Products successfully imported");
        }
    }

    private void _importThemePortletSettings(ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("theme-portlet-settings.json");
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this._portletSettingsImporter.importPortletSettings(jsonArray, this._speedwellDependencyResolver.getDisplayTemplatesClassLoader(), this._speedwellDependencyResolver.getDisplayTemplatesDependencyPath(), serviceContext.getScopeGroupId(), company.getGroupId(), serviceContext.getUserId());
    }
}

