/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.theme.minium.site.initializer.internal;

import com.liferay.commerce.account.util.CommerceAccountRoleHelper;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.initializer.util.AssetCategoriesImporter;
import com.liferay.commerce.initializer.util.CPDefinitionsImporter;
import com.liferay.commerce.initializer.util.CPOptionCategoriesImporter;
import com.liferay.commerce.initializer.util.CPOptionsImporter;
import com.liferay.commerce.initializer.util.CPRulesImporter;
import com.liferay.commerce.initializer.util.CPSpecificationOptionsImporter;
import com.liferay.commerce.initializer.util.CommerceAccountsImporter;
import com.liferay.commerce.initializer.util.CommercePriceEntriesImporter;
import com.liferay.commerce.initializer.util.CommercePriceListsImporter;
import com.liferay.commerce.initializer.util.CommerceUserSegmentsImporter;
import com.liferay.commerce.initializer.util.CommerceUsersImporter;
import com.liferay.commerce.initializer.util.CommerceWarehousesImporter;
import com.liferay.commerce.initializer.util.OrganizationImporter;
import com.liferay.commerce.initializer.util.PortletSettingsImporter;
import com.liferay.commerce.media.CommerceCatalogDefaultImage;
import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.CommerceWarehouse;
import com.liferay.commerce.product.importer.CPFileImporter;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPDefinitionLinkLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.service.CPRuleLocalService;
import com.liferay.commerce.product.service.CPRuleUserSegmentRelLocalService;
import com.liferay.commerce.product.service.CPSpecificationOptionLocalService;
import com.liferay.commerce.service.CommerceCountryLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalService;
import com.liferay.commerce.theme.minium.SiteInitializerDependencyResolver;
import com.liferay.commerce.theme.minium.SiteInitializerDependencyResolverThreadLocal;
import com.liferay.commerce.theme.minium.site.initializer.internal.MiniumLayoutsInitializer;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentEntryLocalService;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"site.initializer.key=minium-initializer"}, service={SiteInitializer.class})
public class MiniumSiteInitializer
implements SiteInitializer {
    public static final String KEY = "minium-initializer";
    private static final String _COMMERCE_VOCABULARY = "Commerce";
    private static final String _MINIUM_THEME_ID = "minium_WAR_miniumtheme";
    private static final Log _log = LogFactoryUtil.getLog(MiniumSiteInitializer.class);
    @Reference
    private AssetCategoriesImporter _assetCategoriesImporter;
    @Reference
    private CommerceAccountRoleHelper _commerceAccountRoleHelper;
    @Reference
    private CommerceAccountsImporter _commerceAccountsImporter;
    @Reference
    private CommerceCatalogDefaultImage _commerceCatalogDefaultImage;
    @Reference
    private CommerceCountryLocalService _commerceCountryLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommercePriceEntriesImporter _commercePriceEntriesImporter;
    @Reference
    private CommercePriceListsImporter _commercePriceListsImporter;
    @Reference
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @Reference
    private CommerceShippingFixedOptionLocalService _commerceShippingFixedOptionLocalService;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private CommerceUserSegmentEntryLocalService _commerceUserSegmentEntryLocalService;
    @Reference
    private CommerceUserSegmentsImporter _commerceUserSegmentsImporter;
    @Reference
    private CommerceUsersImporter _commerceUsersImporter;
    @Reference
    private CommerceWarehousesImporter _commerceWarehousesImporter;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private CPDefinitionLinkLocalService _cpDefinitionLinkLocalService;
    private Map<String, CPDefinition> _cpDefinitions;
    @Reference
    private CPDefinitionsImporter _cpDefinitionsImporter;
    @Reference
    private CPFileImporter _cpFileImporter;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private CPOptionCategoriesImporter _cpOptionCategoriesImporter;
    @Reference
    private CPOptionsImporter _cpOptionsImporter;
    @Reference
    private CPRuleLocalService _cpRuleLocalService;
    @Reference
    private CPRulesImporter _cpRulesImporter;
    @Reference
    private CPRuleUserSegmentRelLocalService _cpRuleUserSegmentRelLocalService;
    @Reference
    private CPSpecificationOptionLocalService _cpSpecificationOptionLocalService;
    @Reference
    private CPSpecificationOptionsImporter _cpSpecificationOptionsImporter;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private MiniumLayoutsInitializer _miniumLayoutsInitializer;
    @Reference
    private OrganizationImporter _organizationImporter;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletSettingsImporter _portletSettingsImporter;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference(target="(osgi.web.symbolicname=com.liferay.commerce.theme.minium.site.initializer)")
    private ServletContext _servletContext;
    @Reference
    private SettingsFactory _settingsFactory;
    @Reference(target="(site.initializer.key=minium-initializer)")
    private SiteInitializerDependencyResolver _siteInitializerDependencyResolver;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"minium-description");
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"minium");
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void init() {
        this._cpDefinitions = new HashMap<String, CPDefinition>();
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            SiteInitializerDependencyResolver siteInitializerDependencyResolver = SiteInitializerDependencyResolverThreadLocal.getSiteInitializerDependencyResolver();
            if (siteInitializerDependencyResolver != null) {
                this._siteInitializerDependencyResolver = siteInitializerDependencyResolver;
            }
            ServiceContext serviceContext = this.getServiceContext(groupId);
            this.configureB2BSite(groupId, serviceContext);
            this._cpFileImporter.updateLookAndFeel(_MINIUM_THEME_ID, true, serviceContext);
            this.updateLogo(serviceContext);
            this.createRoles(serviceContext);
            this._miniumLayoutsInitializer.initialize(serviceContext);
            this._importAssetCategories(serviceContext);
            this._importCPOptionCategories(serviceContext);
            this._importCPSpecificationOptions(serviceContext);
            List<CommerceWarehouse> commerceWarehouses = this._importCommerceWarehouses(serviceContext);
            this._importCPOptions(serviceContext);
            List<CPDefinition> cpDefinitions = this._importCPDefinitions(commerceWarehouses, serviceContext);
            this._importRelatedProducts(cpDefinitions, serviceContext);
            this._importCommercePriceLists(serviceContext);
            this._importCommercePriceEntries(serviceContext);
            this._importCommerceOrganizations(serviceContext);
            this._importCommerceAccounts(serviceContext);
            this._importCommerceUsers(serviceContext);
            this._importCommerceUserSegments(serviceContext);
            this._importCPRules(serviceContext);
            this._importThemePortletSettings(serviceContext);
            this._importPortletSettings(serviceContext);
            this.setCommerceShippingMethod("fixed", serviceContext);
            this.setDefaultCatalogImage(serviceContext);
            this.setThemeSettings(serviceContext);
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new InitializationException((Throwable)e);
        }
    }

    public boolean isActive(long companyId) {
        Theme theme = this._themeLocalService.fetchTheme(companyId, _MINIUM_THEME_ID);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"minium_WAR_miniumtheme is not registered");
            }
            return false;
        }
        return true;
    }

    @Activate
    protected void activate() {
        this.init();
    }

    protected void configureB2BSite(long groupId, ServiceContext serviceContext) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        group.setType(3);
        group.setManualMembership(true);
        group.setMembershipRestriction(0);
        this._groupLocalService.updateGroup(group);
        this._commerceCountryLocalService.importDefaultCountries(serviceContext);
        this._commerceCurrencyLocalService.importDefaultValues(serviceContext);
        this._commerceUserSegmentEntryLocalService.importSystemCommerceUserSegmentEntries(serviceContext);
        this._commerceWarehousesImporter.importDefaultCommerceWarehouse(serviceContext.getScopeGroupId(), serviceContext.getUserId());
        this._cpMeasurementUnitLocalService.importDefaultValues(serviceContext);
        this._commerceAccountRoleHelper.checkCommerceAccountRoles(serviceContext);
        Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.account"));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.setValue("commerceSiteType", String.valueOf(1));
        modifiableSettings.store();
    }

    protected void createRoles(ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("roles.json");
        this._cpFileImporter.createRoles(jsonArray, serviceContext);
        this.updateUserRole(serviceContext);
    }

    @Deactivate
    protected void deactivate() {
        this._cpDefinitions = null;
    }

    protected CPDefinition getCPDefinitionByName(String name) {
        return this._cpDefinitions.get(name);
    }

    protected ServiceContext getServiceContext(long groupId) throws PortalException {
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        Group group = this._groupLocalService.getGroup(groupId);
        Locale locale = LocaleUtil.getSiteDefault();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCompanyId(group.getCompanyId());
        serviceContext.setLanguageId(LanguageUtil.getLanguageId((Locale)locale));
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setTimeZone(user.getTimeZone());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    protected void setCommerceShippingMethod(String shippingMethod, ServiceContext serviceContext) throws PortalException {
        Locale locale = serviceContext.getLocale();
        CommerceShippingEngine commerceShippingEngine = this._commerceShippingEngineRegistry.getCommerceShippingEngine(shippingMethod);
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        nameMap.put(locale, commerceShippingEngine.getName(locale));
        descriptionMap.put(locale, commerceShippingEngine.getDescription(locale));
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.addCommerceShippingMethod(nameMap, descriptionMap, null, shippingMethod, 0.0, true, serviceContext);
        this.setCommerceShippingOption(commerceShippingMethod.getCommerceShippingMethodId(), "Standard Delivery", "", BigDecimal.valueOf(15L), serviceContext);
        this.setCommerceShippingOption(commerceShippingMethod.getCommerceShippingMethodId(), "Expedited Delivery", "", BigDecimal.valueOf(25L), serviceContext);
    }

    protected void setCommerceShippingOption(long commerceShippingMethodId, String name, String description, BigDecimal price, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        nameMap.put(serviceContext.getLocale(), name);
        descriptionMap.put(serviceContext.getLocale(), description);
        this._commerceShippingFixedOptionLocalService.addCommerceShippingFixedOption(commerceShippingMethodId, nameMap, descriptionMap, price, 0.0, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultCatalogImage(ServiceContext serviceContext) throws Exception {
        ClassLoader classLoader = this._siteInitializerDependencyResolver.getImageClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this._siteInitializerDependencyResolver.getImageDependencyPath() + "Minium_ProductImage_Default.png");
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            String mimeType = MimeTypesUtil.getContentType((File)file);
            FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)serviceContext.getScopeGroupId(), (long)serviceContext.getUserId(), (String)MiniumSiteInitializer.class.getName(), (String)file.getName(), (File)file, (String)mimeType);
            this._commerceCatalogDefaultImage.updateDefaultCatalogFileEntryId(serviceContext.getScopeGroupId(), fileEntry.getFileEntryId());
        }
        finally {
            if (file != null) {
                FileUtil.delete((File)file);
            }
        }
    }

    protected void setThemeSettings(ServiceContext serviceContext) throws Exception {
        JSONObject themeSettingsJSONObject = this._getJSONObject("theme-settings.json");
        Iterator iterator = themeSettingsJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = themeSettingsJSONObject.getString(key);
            this.updateThemeSetting(key, value, serviceContext);
        }
    }

    protected void updateLogo(ServiceContext serviceContext) throws Exception {
        ClassLoader classLoader = this._siteInitializerDependencyResolver.getImageClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this._siteInitializerDependencyResolver.getImageDependencyPath() + "minium-logo.png");
        File file = FileUtil.createTempFile((InputStream)inputStream);
        this._cpFileImporter.updateLogo(file, true, true, serviceContext);
    }

    protected void updateThemeSetting(String key, String value, ServiceContext serviceContext) {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), _MINIUM_THEME_ID);
        if (theme == null) {
            return;
        }
        Map configurableSettings = theme.getConfigurableSettings();
        ThemeSetting themeSetting = (ThemeSetting)configurableSettings.get(key);
        themeSetting.setValue(value);
    }

    protected void updateUserRole(ServiceContext serviceContext) throws PortalException {
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), "User");
        this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), "com.liferay.commerce.product", 3, String.valueOf(0L), role.getRoleId(), "VIEW_PRICE");
    }

    private long[] _getCProductIds(JSONArray jsonArray) {
        ArrayList<Long> cProductIdsList = new ArrayList<Long>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            CPDefinition cpDefinitionEntry = this.getCPDefinitionByName(jsonArray.getString(i));
            cProductIdsList.add(cpDefinitionEntry.getCProductId());
        }
        return ArrayUtil.toLongArray(cProductIdsList);
    }

    private JSONArray _getJSONArray(String name) throws Exception {
        String json = this._siteInitializerDependencyResolver.getJSON(name);
        return this._jsonFactory.createJSONArray(json);
    }

    private JSONObject _getJSONObject(String name) throws Exception {
        String json = this._siteInitializerDependencyResolver.getJSON(name);
        return this._jsonFactory.createJSONObject(json);
    }

    private void _importAssetCategories(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing asset categories...");
        }
        JSONArray jsonArray = this._getJSONArray("categories.json");
        this._assetCategoriesImporter.importAssetCategories(jsonArray, _COMMERCE_VOCABULARY, this._siteInitializerDependencyResolver.getImageClassLoader(), this._siteInitializerDependencyResolver.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Asset categories successfully imported");
        }
    }

    private void _importCommerceAccounts(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Accounts...");
        }
        JSONArray jsonArray = this._getJSONArray("accounts.json");
        this._commerceAccountsImporter.importCommerceAccounts(jsonArray, this._siteInitializerDependencyResolver.getImageClassLoader(), this._siteInitializerDependencyResolver.getDependenciesPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Accounts successfully imported");
        }
    }

    private void _importCommerceOrganizations(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing organizations...");
        }
        JSONArray jsonArray = this._getJSONArray("organizations.json");
        this._organizationImporter.importOrganizations(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Organizations successfully imported");
        }
    }

    private void _importCommercePriceEntries(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce price entries...");
        }
        JSONArray jsonArray = this._getJSONArray("price-entries.json");
        this._commercePriceEntriesImporter.importCommercePriceEntries(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce price entries successfully imported");
        }
    }

    private void _importCommercePriceLists(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce price lists...");
        }
        JSONArray jsonArray = this._getJSONArray("price-lists.json");
        this._commercePriceListsImporter.importCommercePriceLists(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce price lists successfully imported");
        }
    }

    private void _importCommerceUsers(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Users...");
        }
        JSONArray jsonArray = this._getJSONArray("users.json");
        this._commerceUsersImporter.importCommerceUsers(jsonArray, this._siteInitializerDependencyResolver.getImageClassLoader(), this._siteInitializerDependencyResolver.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Users successfully imported");
        }
    }

    private void _importCommerceUserSegments(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce User Segments...");
        }
        JSONArray jsonArray = this._getJSONArray("segments.json");
        this._commerceUserSegmentsImporter.importCommerceUserSegments(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce User Segments successfully imported");
        }
    }

    private List<CommerceWarehouse> _importCommerceWarehouses(ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("warehouses.json");
        return this._commerceWarehousesImporter.importCommerceWarehouses(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private List<CPDefinition> _importCPDefinitions(List<CommerceWarehouse> commerceWarehouses, ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("products.json");
        long[] commerceWarehouseIds = ListUtil.toLongArray(commerceWarehouses, (Accessor)CommerceWarehouse.COMMERCE_WAREHOUSE_ID_ACCESSOR);
        return this._cpDefinitionsImporter.importCPDefinitions(jsonArray, _COMMERCE_VOCABULARY, commerceWarehouseIds, this._siteInitializerDependencyResolver.getImageClassLoader(), this._siteInitializerDependencyResolver.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _importCPOptionCategories(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce product option categories...");
        }
        JSONArray jsonArray = this._getJSONArray("option-categories.json");
        this._cpOptionCategoriesImporter.importCPOptionCategories(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce product option categories successfully imported");
        }
    }

    private List<CPOption> _importCPOptions(ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("options.json");
        return this._cpOptionsImporter.importCPOptions(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _importCPRules(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing CPRules...");
        }
        JSONArray jsonArray = this._getJSONArray("catalog-rules.json");
        this._cpRulesImporter.importCPRules(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"CPRules imported");
        }
    }

    private void _importCPSpecificationOptions(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce product specification options...");
        }
        JSONArray jsonArray = this._getJSONArray("specification-options.json");
        this._cpSpecificationOptionsImporter.importCPSpecificationOptions(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce product specification options successfully imported");
        }
    }

    private void _importPortletSettings(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing portlet settings...");
        }
        JSONArray jsonArray = this._getJSONArray("portlet-settings.json");
        this._portletSettingsImporter.importPortletSettings(jsonArray, this._siteInitializerDependencyResolver.getDisplayTemplatesClassLoader(), this._siteInitializerDependencyResolver.getDisplayTemplatesDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Portlet settings successfully imported");
        }
    }

    private void _importRelatedProducts(JSONArray jsonArray, ServiceContext serviceContext) throws Exception {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject productJSONObject = jsonArray.getJSONObject(i);
            String name = productJSONObject.getString("Name");
            CPDefinition cpDefinition = this.getCPDefinitionByName(name);
            JSONArray relatedProducts = productJSONObject.getJSONArray("RelatedProducts");
            if (relatedProducts == null) continue;
            this._cpDefinitionLinkLocalService.updateCPDefinitionLinkCProductIds(cpDefinition.getCPDefinitionId(), this._getCProductIds(relatedProducts), "related", serviceContext);
        }
    }

    private void _importRelatedProducts(List<CPDefinition> cpDefinitions, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing related products...");
        }
        for (CPDefinition cpDefinition : cpDefinitions) {
            this._cpDefinitions.put(cpDefinition.getName(serviceContext.getLanguageId()), cpDefinition);
        }
        JSONArray jsonArray = this._getJSONArray("products.json");
        this._importRelatedProducts(jsonArray, serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Related products successfully imported");
        }
    }

    private void _importThemePortletSettings(ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("theme-portlet-settings.json");
        this._portletSettingsImporter.importPortletSettings(jsonArray, this._siteInitializerDependencyResolver.getDisplayTemplatesClassLoader(), this._siteInitializerDependencyResolver.getDisplayTemplatesDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }
}

