/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.term.internal.search.spi.model.index.contributor;

import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.CommerceTermEntryLocalService;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;

import java.util.List;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	enabled = false, immediate = true,
	property = "indexer.class.name=com.liferay.commerce.term.model.CommerceTermEntry",
	service = ModelDocumentContributor.class
)
public class CommerceTermEntryModelDocumentContributor
	implements ModelDocumentContributor<CommerceTermEntry> {

	@Override
	public void contribute(
		Document document, CommerceTermEntry commerceTermEntry) {

		document.addKeyword(Field.NAME, commerceTermEntry.getName());
		document.addNumberSortable(
			Field.PRIORITY, commerceTermEntry.getPriority());
		document.addText(Field.TYPE, commerceTermEntry.getType());

		List<String> languageIds =
			_commerceTermEntryLocalService.getCTermEntryLocalizationLanguageIds(
				commerceTermEntry.getCommerceTermEntryId());

		for (String languageId : languageIds) {
			document.addKeywordSortable(
				LocalizationUtil.getLocalizedName("label", languageId),
				commerceTermEntry.getLabel(languageId));
		}
	}

	@Reference
	private CommerceTermEntryLocalService _commerceTermEntryLocalService;

}