/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.term.service.impl;

import com.liferay.commerce.term.constants.CommerceTermEntryActionKeys;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.base.CommerceTermEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.ActionKeys;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;

import java.util.Locale;
import java.util.Map;

import org.osgi.service.component.annotations.Component;

/**
 * @author Luca Pellizzon
 * @author Alessio Antonio Rendina
 */
@Component(
	enabled = false,
	property = {
		"json.web.service.context.name=commerce",
		"json.web.service.context.path=CommerceTermEntry"
	},
	service = AopService.class
)
public class CommerceTermEntryServiceImpl
	extends CommerceTermEntryServiceBaseImpl {

	@Override
	public CommerceTermEntry addCommerceTermEntry(
			String externalReferenceCode, boolean active,
			Map<Locale, String> descriptionMap, int displayDateMonth,
			int displayDateDay, int displayDateYear, int displayDateHour,
			int displayDateMinute, int expirationDateMonth,
			int expirationDateDay, int expirationDateYear,
			int expirationDateHour, int expirationDateMinute,
			boolean neverExpire, Map<Locale, String> labelMap, String name,
			double priority, String type, String typeSettings,
			ServiceContext serviceContext)
		throws PortalException {

		PortletResourcePermission portletResourcePermission =
			_commerceTermEntryModelResourcePermission.
				getPortletResourcePermission();

		portletResourcePermission.check(
			getPermissionChecker(), null,
			CommerceTermEntryActionKeys.ADD_COMMERCE_TERM_ENTRY);

		return commerceTermEntryLocalService.addCommerceTermEntry(
			externalReferenceCode, getUserId(), active, descriptionMap,
			displayDateMonth, displayDateDay, displayDateYear, displayDateHour,
			displayDateMinute, expirationDateMonth, expirationDateDay,
			expirationDateYear, expirationDateHour, expirationDateMinute,
			neverExpire, labelMap, name, priority, type, typeSettings,
			serviceContext);
	}

	@Override
	public CommerceTermEntry deleteCommerceTermEntry(long commerceTermEntryId)
		throws PortalException {

		_commerceTermEntryModelResourcePermission.check(
			getPermissionChecker(), commerceTermEntryId, ActionKeys.DELETE);

		return commerceTermEntryLocalService.deleteCommerceTermEntry(
			commerceTermEntryId);
	}

	@Override
	public CommerceTermEntry fetchByExternalReferenceCode(
			long companyId, String externalReferenceCode)
		throws PortalException {

		CommerceTermEntry commerceTermEntry =
			commerceTermEntryLocalService.
				fetchCommerceTermEntryByExternalReferenceCode(
					companyId, externalReferenceCode);

		if (commerceTermEntry != null) {
			_commerceTermEntryModelResourcePermission.check(
				getPermissionChecker(), commerceTermEntry, ActionKeys.VIEW);
		}

		return commerceTermEntry;
	}

	@Override
	public CommerceTermEntry fetchCommerceTermEntry(long commerceTermEntryId)
		throws PortalException {

		CommerceTermEntry commerceTermEntry =
			commerceTermEntryLocalService.fetchCommerceTermEntry(
				commerceTermEntryId);

		if (commerceTermEntry != null) {
			_commerceTermEntryModelResourcePermission.check(
				getPermissionChecker(), commerceTermEntry, ActionKeys.VIEW);
		}

		return commerceTermEntry;
	}

	@Override
	public CommerceTermEntry getCommerceTermEntry(long commerceTermEntryId)
		throws PortalException {

		_commerceTermEntryModelResourcePermission.check(
			getPermissionChecker(), commerceTermEntryId, ActionKeys.VIEW);

		return commerceTermEntryLocalService.getCommerceTermEntry(
			commerceTermEntryId);
	}

	@Override
	public CommerceTermEntry updateCommerceTermEntry(
			long commerceTermEntryId, boolean active,
			Map<Locale, String> descriptionMap, int displayDateMonth,
			int displayDateDay, int displayDateYear, int displayDateHour,
			int displayDateMinute, int expirationDateMonth,
			int expirationDateDay, int expirationDateYear,
			int expirationDateHour, int expirationDateMinute,
			boolean neverExpire, Map<Locale, String> labelMap, String name,
			double priority, String typeSettings, ServiceContext serviceContext)
		throws PortalException {

		_commerceTermEntryModelResourcePermission.check(
			getPermissionChecker(), commerceTermEntryId, ActionKeys.UPDATE);

		return commerceTermEntryLocalService.updateCommerceTermEntry(
			getUserId(), commerceTermEntryId, active, descriptionMap,
			displayDateMonth, displayDateDay, displayDateYear, displayDateHour,
			displayDateMinute, expirationDateMonth, expirationDateDay,
			expirationDateYear, expirationDateHour, expirationDateMinute,
			neverExpire, labelMap, name, priority, typeSettings,
			serviceContext);
	}

	@Override
	public CommerceTermEntry updateCommerceTermEntryExternalReferenceCode(
			String externalReferenceCode, long commerceTermEntryId)
		throws PortalException {

		_commerceTermEntryModelResourcePermission.check(
			getPermissionChecker(), commerceTermEntryId, ActionKeys.UPDATE);

		return commerceTermEntryLocalService.
			updateCommerceTermEntryExternalReferenceCode(
				externalReferenceCode, commerceTermEntryId);
	}

	private static volatile ModelResourcePermission<CommerceTermEntry>
		_commerceTermEntryModelResourcePermission =
			ModelResourcePermissionFactory.getInstance(
				CommerceTermEntryServiceImpl.class,
				"_commerceTermEntryModelResourcePermission",
				CommerceTermEntry.class);

}