/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.term.model.impl;

import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.CommerceTermEntryLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceTermEntry service. Represents a row in the &quot;CommerceTermEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceTermEntryImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceTermEntryImpl
 * @see CommerceTermEntry
 * @generated
 */
public abstract class CommerceTermEntryBaseImpl
	extends CommerceTermEntryModelImpl implements CommerceTermEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce term entry model instance should use the <code>CommerceTermEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceTermEntryLocalServiceUtil.addCommerceTermEntry(this);
		}
		else {
			CommerceTermEntryLocalServiceUtil.updateCommerceTermEntry(this);
		}
	}

}