/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.term.internal.security.permission.resource;

import com.liferay.commerce.term.model.CommerceTermEntryRel;
import com.liferay.commerce.term.permission.CommerceTermEntryPermission;
import com.liferay.commerce.term.service.CommerceTermEntryRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	enabled = false, immediate = true,
	property = "model.class.name=com.liferay.commerce.term.model.CommerceTermEntryRel",
	service = ModelResourcePermission.class
)
public class CommerceTermEntryRelModelResourcePermission
	implements ModelResourcePermission<CommerceTermEntryRel> {

	@Override
	public void check(
			PermissionChecker permissionChecker,
			CommerceTermEntryRel commerceTermEntryRel, String actionId)
		throws PortalException {

		_commerceTermEntryPermission.check(
			permissionChecker, commerceTermEntryRel.getCommerceTermEntryId(),
			actionId);
	}

	@Override
	public void check(
			PermissionChecker permissionChecker, long commerceTermEntryRelId,
			String actionId)
		throws PortalException {

		CommerceTermEntryRel commerceTermEntryRel =
			_commerceTermEntryRelLocalService.getCommerceTermEntryRel(
				commerceTermEntryRelId);

		_commerceTermEntryPermission.check(
			permissionChecker, commerceTermEntryRel.getCommerceTermEntryId(),
			actionId);
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker,
			CommerceTermEntryRel commerceTermEntryRel, String actionId)
		throws PortalException {

		return _commerceTermEntryPermission.contains(
			permissionChecker, commerceTermEntryRel.getCommerceTermEntryId(),
			actionId);
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker, long commerceTermEntryRelId,
			String actionId)
		throws PortalException {

		CommerceTermEntryRel commerceTermEntryRel =
			_commerceTermEntryRelLocalService.getCommerceTermEntryRel(
				commerceTermEntryRelId);

		return _commerceTermEntryPermission.contains(
			permissionChecker, commerceTermEntryRel.getCommerceTermEntryId(),
			actionId);
	}

	@Override
	public String getModelName() {
		return CommerceTermEntryRel.class.getName();
	}

	@Override
	public PortletResourcePermission getPortletResourcePermission() {
		return null;
	}

	@Reference
	private CommerceTermEntryPermission _commerceTermEntryPermission;

	@Reference
	private CommerceTermEntryRelLocalService _commerceTermEntryRelLocalService;

}