/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.term.model.impl;

import com.liferay.commerce.term.model.CTermEntryLocalization;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.model.CommerceTermEntryModel;
import com.liferay.commerce.term.service.CommerceTermEntryLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceTermEntry service. Represents a row in the &quot;CommerceTermEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceTermEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceTermEntryImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceTermEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceTermEntryModelImpl
	extends BaseModelImpl<CommerceTermEntry> implements CommerceTermEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce term entry model instance should use the <code>CommerceTermEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceTermEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"defaultLanguageId", Types.VARCHAR},
		{"commerceTermEntryId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"active_", Types.BOOLEAN}, {"displayDate", Types.TIMESTAMP},
		{"expirationDate", Types.TIMESTAMP}, {"name", Types.VARCHAR},
		{"priority", Types.DOUBLE}, {"type_", Types.VARCHAR},
		{"typeSettings", Types.VARCHAR}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("defaultLanguageId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceTermEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("typeSettings", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceTermEntry (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,defaultLanguageId VARCHAR(75) null,commerceTermEntryId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,active_ BOOLEAN,displayDate DATE null,expirationDate DATE null,name VARCHAR(75) null,priority DOUBLE,type_ VARCHAR(75) null,typeSettings VARCHAR(75) null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table CommerceTermEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceTermEntry.priority DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceTermEntry.priority DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DISPLAYDATE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXPIRATIONDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommerceTermEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceTermEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceTermEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceTermEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceTermEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceTermEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceTermEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceTermEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTermEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceTermEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceTermEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceTermEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceTermEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceTermEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceTermEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<CommerceTermEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceTermEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceTermEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceTermEntry, Object>>();
		Map<String, BiConsumer<CommerceTermEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CommerceTermEntry, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", CommerceTermEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommerceTermEntry, Long>)
				CommerceTermEntry::setMvccVersion);
		attributeGetterFunctions.put("uuid", CommerceTermEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommerceTermEntry, String>)CommerceTermEntry::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			CommerceTermEntry::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommerceTermEntry, String>)
				CommerceTermEntry::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"defaultLanguageId", CommerceTermEntry::getDefaultLanguageId);
		attributeSetterBiConsumers.put(
			"defaultLanguageId",
			(BiConsumer<CommerceTermEntry, String>)
				CommerceTermEntry::setDefaultLanguageId);
		attributeGetterFunctions.put(
			"commerceTermEntryId", CommerceTermEntry::getCommerceTermEntryId);
		attributeSetterBiConsumers.put(
			"commerceTermEntryId",
			(BiConsumer<CommerceTermEntry, Long>)
				CommerceTermEntry::setCommerceTermEntryId);
		attributeGetterFunctions.put(
			"companyId", CommerceTermEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceTermEntry, Long>)
				CommerceTermEntry::setCompanyId);
		attributeGetterFunctions.put("userId", CommerceTermEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceTermEntry, Long>)CommerceTermEntry::setUserId);
		attributeGetterFunctions.put(
			"userName", CommerceTermEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceTermEntry, String>)
				CommerceTermEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceTermEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceTermEntry, Date>)
				CommerceTermEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceTermEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceTermEntry, Date>)
				CommerceTermEntry::setModifiedDate);
		attributeGetterFunctions.put("active", CommerceTermEntry::getActive);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<CommerceTermEntry, Boolean>)
				CommerceTermEntry::setActive);
		attributeGetterFunctions.put(
			"displayDate", CommerceTermEntry::getDisplayDate);
		attributeSetterBiConsumers.put(
			"displayDate",
			(BiConsumer<CommerceTermEntry, Date>)
				CommerceTermEntry::setDisplayDate);
		attributeGetterFunctions.put(
			"expirationDate", CommerceTermEntry::getExpirationDate);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<CommerceTermEntry, Date>)
				CommerceTermEntry::setExpirationDate);
		attributeGetterFunctions.put("name", CommerceTermEntry::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<CommerceTermEntry, String>)CommerceTermEntry::setName);
		attributeGetterFunctions.put(
			"priority", CommerceTermEntry::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<CommerceTermEntry, Double>)
				CommerceTermEntry::setPriority);
		attributeGetterFunctions.put("type", CommerceTermEntry::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<CommerceTermEntry, String>)CommerceTermEntry::setType);
		attributeGetterFunctions.put(
			"typeSettings", CommerceTermEntry::getTypeSettings);
		attributeSetterBiConsumers.put(
			"typeSettings",
			(BiConsumer<CommerceTermEntry, String>)
				CommerceTermEntry::setTypeSettings);
		attributeGetterFunctions.put(
			"lastPublishDate", CommerceTermEntry::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<CommerceTermEntry, Date>)
				CommerceTermEntry::setLastPublishDate);
		attributeGetterFunctions.put("status", CommerceTermEntry::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<CommerceTermEntry, Integer>)
				CommerceTermEntry::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", CommerceTermEntry::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<CommerceTermEntry, Long>)
				CommerceTermEntry::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", CommerceTermEntry::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<CommerceTermEntry, String>)
				CommerceTermEntry::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", CommerceTermEntry::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<CommerceTermEntry, Date>)
				CommerceTermEntry::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		List<CTermEntryLocalization> cTermEntryLocalizations =
			CommerceTermEntryLocalServiceUtil.getCTermEntryLocalizations(
				getPrimaryKey());

		String[] availableLanguageIds =
			new String[cTermEntryLocalizations.size()];

		for (int i = 0; i < availableLanguageIds.length; i++) {
			CTermEntryLocalization cTermEntryLocalization =
				cTermEntryLocalizations.get(i);

			availableLanguageIds[i] = cTermEntryLocalization.getLanguageId();
		}

		return availableLanguageIds;
	}

	@Override
	public String getDescription() {
		return getDescription(getDefaultLanguageId(), false);
	}

	@Override
	public String getDescription(String languageId) {
		return getDescription(languageId, true);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		if (useDefault) {
			return LocalizationUtil.getLocalization(
				new Function<String, String>() {

					@Override
					public String apply(String languageId) {
						return _getDescription(languageId);
					}

				},
				languageId, getDefaultLanguageId());
		}

		return _getDescription(languageId);
	}

	@Override
	public String getDescriptionMapAsXML() {
		return LocalizationUtil.getXml(
			getLanguageIdToDescriptionMap(), getDefaultLanguageId(),
			"Description");
	}

	@Override
	public Map<String, String> getLanguageIdToDescriptionMap() {
		Map<String, String> languageIdToDescriptionMap =
			new HashMap<String, String>();

		List<CTermEntryLocalization> cTermEntryLocalizations =
			CommerceTermEntryLocalServiceUtil.getCTermEntryLocalizations(
				getPrimaryKey());

		for (CTermEntryLocalization cTermEntryLocalization :
				cTermEntryLocalizations) {

			languageIdToDescriptionMap.put(
				cTermEntryLocalization.getLanguageId(),
				cTermEntryLocalization.getDescription());
		}

		return languageIdToDescriptionMap;
	}

	private String _getDescription(String languageId) {
		CTermEntryLocalization cTermEntryLocalization =
			CommerceTermEntryLocalServiceUtil.fetchCTermEntryLocalization(
				getPrimaryKey(), languageId);

		if (cTermEntryLocalization == null) {
			return "";
		}

		return cTermEntryLocalization.getDescription();
	}

	@Override
	public String getLabel() {
		return getLabel(getDefaultLanguageId(), false);
	}

	@Override
	public String getLabel(String languageId) {
		return getLabel(languageId, true);
	}

	@Override
	public String getLabel(String languageId, boolean useDefault) {
		if (useDefault) {
			return LocalizationUtil.getLocalization(
				new Function<String, String>() {

					@Override
					public String apply(String languageId) {
						return _getLabel(languageId);
					}

				},
				languageId, getDefaultLanguageId());
		}

		return _getLabel(languageId);
	}

	@Override
	public String getLabelMapAsXML() {
		return LocalizationUtil.getXml(
			getLanguageIdToLabelMap(), getDefaultLanguageId(), "Label");
	}

	@Override
	public Map<String, String> getLanguageIdToLabelMap() {
		Map<String, String> languageIdToLabelMap =
			new HashMap<String, String>();

		List<CTermEntryLocalization> cTermEntryLocalizations =
			CommerceTermEntryLocalServiceUtil.getCTermEntryLocalizations(
				getPrimaryKey());

		for (CTermEntryLocalization cTermEntryLocalization :
				cTermEntryLocalizations) {

			languageIdToLabelMap.put(
				cTermEntryLocalization.getLanguageId(),
				cTermEntryLocalization.getLabel());
		}

		return languageIdToLabelMap;
	}

	private String _getLabel(String languageId) {
		CTermEntryLocalization cTermEntryLocalization =
			CommerceTermEntryLocalServiceUtil.fetchCTermEntryLocalization(
				getPrimaryKey(), languageId);

		if (cTermEntryLocalization == null) {
			return "";
		}

		return cTermEntryLocalization.getLabel();
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public String getDefaultLanguageId() {
		if (_defaultLanguageId == null) {
			return "";
		}
		else {
			return _defaultLanguageId;
		}
	}

	@Override
	public void setDefaultLanguageId(String defaultLanguageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultLanguageId = defaultLanguageId;
	}

	@JSON
	@Override
	public long getCommerceTermEntryId() {
		return _commerceTermEntryId;
	}

	@Override
	public void setCommerceTermEntryId(long commerceTermEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceTermEntryId = commerceTermEntryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalDisplayDate() {
		return getColumnOriginalValue("displayDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalExpirationDate() {
		return getColumnOriginalValue("expirationDate");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public double getOriginalPriority() {
		return GetterUtil.getDouble(
			this.<Double>getColumnOriginalValue("priority"));
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalType() {
		return getColumnOriginalValue("type_");
	}

	@JSON
	@Override
	public String getTypeSettings() {
		if (_typeSettings == null) {
			return "";
		}
		else {
			return _typeSettings;
		}
	}

	@Override
	public void setTypeSettings(String typeSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typeSettings = typeSettings;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommerceTermEntry.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceTermEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceTermEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceTermEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceTermEntryImpl commerceTermEntryImpl =
			new CommerceTermEntryImpl();

		commerceTermEntryImpl.setMvccVersion(getMvccVersion());
		commerceTermEntryImpl.setUuid(getUuid());
		commerceTermEntryImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceTermEntryImpl.setDefaultLanguageId(getDefaultLanguageId());
		commerceTermEntryImpl.setCommerceTermEntryId(getCommerceTermEntryId());
		commerceTermEntryImpl.setCompanyId(getCompanyId());
		commerceTermEntryImpl.setUserId(getUserId());
		commerceTermEntryImpl.setUserName(getUserName());
		commerceTermEntryImpl.setCreateDate(getCreateDate());
		commerceTermEntryImpl.setModifiedDate(getModifiedDate());
		commerceTermEntryImpl.setActive(isActive());
		commerceTermEntryImpl.setDisplayDate(getDisplayDate());
		commerceTermEntryImpl.setExpirationDate(getExpirationDate());
		commerceTermEntryImpl.setName(getName());
		commerceTermEntryImpl.setPriority(getPriority());
		commerceTermEntryImpl.setType(getType());
		commerceTermEntryImpl.setTypeSettings(getTypeSettings());
		commerceTermEntryImpl.setLastPublishDate(getLastPublishDate());
		commerceTermEntryImpl.setStatus(getStatus());
		commerceTermEntryImpl.setStatusByUserId(getStatusByUserId());
		commerceTermEntryImpl.setStatusByUserName(getStatusByUserName());
		commerceTermEntryImpl.setStatusDate(getStatusDate());

		commerceTermEntryImpl.resetOriginalValues();

		return commerceTermEntryImpl;
	}

	@Override
	public CommerceTermEntry cloneWithOriginalValues() {
		CommerceTermEntryImpl commerceTermEntryImpl =
			new CommerceTermEntryImpl();

		commerceTermEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceTermEntryImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		commerceTermEntryImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		commerceTermEntryImpl.setDefaultLanguageId(
			this.<String>getColumnOriginalValue("defaultLanguageId"));
		commerceTermEntryImpl.setCommerceTermEntryId(
			this.<Long>getColumnOriginalValue("commerceTermEntryId"));
		commerceTermEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceTermEntryImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceTermEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceTermEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceTermEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceTermEntryImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));
		commerceTermEntryImpl.setDisplayDate(
			this.<Date>getColumnOriginalValue("displayDate"));
		commerceTermEntryImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		commerceTermEntryImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		commerceTermEntryImpl.setPriority(
			this.<Double>getColumnOriginalValue("priority"));
		commerceTermEntryImpl.setType(
			this.<String>getColumnOriginalValue("type_"));
		commerceTermEntryImpl.setTypeSettings(
			this.<String>getColumnOriginalValue("typeSettings"));
		commerceTermEntryImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		commerceTermEntryImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		commerceTermEntryImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		commerceTermEntryImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		commerceTermEntryImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return commerceTermEntryImpl;
	}

	@Override
	public int compareTo(CommerceTermEntry commerceTermEntry) {
		int value = 0;

		if (getPriority() < commerceTermEntry.getPriority()) {
			value = -1;
		}
		else if (getPriority() > commerceTermEntry.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceTermEntry)) {
			return false;
		}

		CommerceTermEntry commerceTermEntry = (CommerceTermEntry)object;

		long primaryKey = commerceTermEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceTermEntry> toCacheModel() {
		CommerceTermEntryCacheModel commerceTermEntryCacheModel =
			new CommerceTermEntryCacheModel();

		commerceTermEntryCacheModel.mvccVersion = getMvccVersion();

		commerceTermEntryCacheModel.uuid = getUuid();

		String uuid = commerceTermEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceTermEntryCacheModel.uuid = null;
		}

		commerceTermEntryCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceTermEntryCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceTermEntryCacheModel.externalReferenceCode = null;
		}

		commerceTermEntryCacheModel.defaultLanguageId = getDefaultLanguageId();

		String defaultLanguageId =
			commerceTermEntryCacheModel.defaultLanguageId;

		if ((defaultLanguageId != null) && (defaultLanguageId.length() == 0)) {
			commerceTermEntryCacheModel.defaultLanguageId = null;
		}

		commerceTermEntryCacheModel.commerceTermEntryId =
			getCommerceTermEntryId();

		commerceTermEntryCacheModel.companyId = getCompanyId();

		commerceTermEntryCacheModel.userId = getUserId();

		commerceTermEntryCacheModel.userName = getUserName();

		String userName = commerceTermEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceTermEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceTermEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceTermEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceTermEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceTermEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceTermEntryCacheModel.active = isActive();

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			commerceTermEntryCacheModel.displayDate = displayDate.getTime();
		}
		else {
			commerceTermEntryCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			commerceTermEntryCacheModel.expirationDate =
				expirationDate.getTime();
		}
		else {
			commerceTermEntryCacheModel.expirationDate = Long.MIN_VALUE;
		}

		commerceTermEntryCacheModel.name = getName();

		String name = commerceTermEntryCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceTermEntryCacheModel.name = null;
		}

		commerceTermEntryCacheModel.priority = getPriority();

		commerceTermEntryCacheModel.type = getType();

		String type = commerceTermEntryCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			commerceTermEntryCacheModel.type = null;
		}

		commerceTermEntryCacheModel.typeSettings = getTypeSettings();

		String typeSettings = commerceTermEntryCacheModel.typeSettings;

		if ((typeSettings != null) && (typeSettings.length() == 0)) {
			commerceTermEntryCacheModel.typeSettings = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			commerceTermEntryCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			commerceTermEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		commerceTermEntryCacheModel.status = getStatus();

		commerceTermEntryCacheModel.statusByUserId = getStatusByUserId();

		commerceTermEntryCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commerceTermEntryCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commerceTermEntryCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commerceTermEntryCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commerceTermEntryCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commerceTermEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceTermEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceTermEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTermEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceTermEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceTermEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceTermEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceTermEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceTermEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceTermEntry>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceTermEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private String _defaultLanguageId;
	private long _commerceTermEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private boolean _active;
	private Date _displayDate;
	private Date _expirationDate;
	private String _name;
	private double _priority;
	private String _type;
	private String _typeSettings;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceTermEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceTermEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("defaultLanguageId", _defaultLanguageId);
		_columnOriginalValues.put("commerceTermEntryId", _commerceTermEntryId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("typeSettings", _typeSettings);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("active_", "active");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("defaultLanguageId", 8L);

		columnBitmasks.put("commerceTermEntryId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("active_", 1024L);

		columnBitmasks.put("displayDate", 2048L);

		columnBitmasks.put("expirationDate", 4096L);

		columnBitmasks.put("name", 8192L);

		columnBitmasks.put("priority", 16384L);

		columnBitmasks.put("type_", 32768L);

		columnBitmasks.put("typeSettings", 65536L);

		columnBitmasks.put("lastPublishDate", 131072L);

		columnBitmasks.put("status", 262144L);

		columnBitmasks.put("statusByUserId", 524288L);

		columnBitmasks.put("statusByUserName", 1048576L);

		columnBitmasks.put("statusDate", 2097152L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceTermEntry _escapedModel;

}