/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.tax.engine.fixed.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommerceTaxFixedRateAddressRel service. Represents a row in the &quot;CommerceTaxFixedRateAddressRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.tax.engine.fixed.model.impl.CommerceTaxFixedRateAddressRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.tax.engine.fixed.model.impl.CommerceTaxFixedRateAddressRelImpl</code>.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceTaxFixedRateAddressRel
 * @generated
 */
@ProviderType
public interface CommerceTaxFixedRateAddressRelModel
	extends BaseModel<CommerceTaxFixedRateAddressRel>, GroupedModel, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce tax fixed rate address rel model instance should use the {@link CommerceTaxFixedRateAddressRel} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce tax fixed rate address rel.
	 *
	 * @return the primary key of this commerce tax fixed rate address rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce tax fixed rate address rel.
	 *
	 * @param primaryKey the primary key of this commerce tax fixed rate address rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this commerce tax fixed rate address rel.
	 *
	 * @return the mvcc version of this commerce tax fixed rate address rel
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this commerce tax fixed rate address rel.
	 *
	 * @param mvccVersion the mvcc version of this commerce tax fixed rate address rel
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the commerce tax fixed rate address rel ID of this commerce tax fixed rate address rel.
	 *
	 * @return the commerce tax fixed rate address rel ID of this commerce tax fixed rate address rel
	 */
	public long getCommerceTaxFixedRateAddressRelId();

	/**
	 * Sets the commerce tax fixed rate address rel ID of this commerce tax fixed rate address rel.
	 *
	 * @param commerceTaxFixedRateAddressRelId the commerce tax fixed rate address rel ID of this commerce tax fixed rate address rel
	 */
	public void setCommerceTaxFixedRateAddressRelId(
		long commerceTaxFixedRateAddressRelId);

	/**
	 * Returns the group ID of this commerce tax fixed rate address rel.
	 *
	 * @return the group ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this commerce tax fixed rate address rel.
	 *
	 * @param groupId the group ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this commerce tax fixed rate address rel.
	 *
	 * @return the company ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce tax fixed rate address rel.
	 *
	 * @param companyId the company ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce tax fixed rate address rel.
	 *
	 * @return the user ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce tax fixed rate address rel.
	 *
	 * @param userId the user ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce tax fixed rate address rel.
	 *
	 * @return the user uuid of this commerce tax fixed rate address rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce tax fixed rate address rel.
	 *
	 * @param userUuid the user uuid of this commerce tax fixed rate address rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce tax fixed rate address rel.
	 *
	 * @return the user name of this commerce tax fixed rate address rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce tax fixed rate address rel.
	 *
	 * @param userName the user name of this commerce tax fixed rate address rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce tax fixed rate address rel.
	 *
	 * @return the create date of this commerce tax fixed rate address rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce tax fixed rate address rel.
	 *
	 * @param createDate the create date of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce tax fixed rate address rel.
	 *
	 * @return the modified date of this commerce tax fixed rate address rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce tax fixed rate address rel.
	 *
	 * @param modifiedDate the modified date of this commerce tax fixed rate address rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce tax method ID of this commerce tax fixed rate address rel.
	 *
	 * @return the commerce tax method ID of this commerce tax fixed rate address rel
	 */
	public long getCommerceTaxMethodId();

	/**
	 * Sets the commerce tax method ID of this commerce tax fixed rate address rel.
	 *
	 * @param commerceTaxMethodId the commerce tax method ID of this commerce tax fixed rate address rel
	 */
	public void setCommerceTaxMethodId(long commerceTaxMethodId);

	/**
	 * Returns the cp tax category ID of this commerce tax fixed rate address rel.
	 *
	 * @return the cp tax category ID of this commerce tax fixed rate address rel
	 */
	public long getCPTaxCategoryId();

	/**
	 * Sets the cp tax category ID of this commerce tax fixed rate address rel.
	 *
	 * @param CPTaxCategoryId the cp tax category ID of this commerce tax fixed rate address rel
	 */
	public void setCPTaxCategoryId(long CPTaxCategoryId);

	/**
	 * Returns the country ID of this commerce tax fixed rate address rel.
	 *
	 * @return the country ID of this commerce tax fixed rate address rel
	 */
	public long getCountryId();

	/**
	 * Sets the country ID of this commerce tax fixed rate address rel.
	 *
	 * @param countryId the country ID of this commerce tax fixed rate address rel
	 */
	public void setCountryId(long countryId);

	/**
	 * Returns the region ID of this commerce tax fixed rate address rel.
	 *
	 * @return the region ID of this commerce tax fixed rate address rel
	 */
	public long getRegionId();

	/**
	 * Sets the region ID of this commerce tax fixed rate address rel.
	 *
	 * @param regionId the region ID of this commerce tax fixed rate address rel
	 */
	public void setRegionId(long regionId);

	/**
	 * Returns the zip of this commerce tax fixed rate address rel.
	 *
	 * @return the zip of this commerce tax fixed rate address rel
	 */
	@AutoEscape
	public String getZip();

	/**
	 * Sets the zip of this commerce tax fixed rate address rel.
	 *
	 * @param zip the zip of this commerce tax fixed rate address rel
	 */
	public void setZip(String zip);

	/**
	 * Returns the rate of this commerce tax fixed rate address rel.
	 *
	 * @return the rate of this commerce tax fixed rate address rel
	 */
	public double getRate();

	/**
	 * Sets the rate of this commerce tax fixed rate address rel.
	 *
	 * @param rate the rate of this commerce tax fixed rate address rel
	 */
	public void setRate(double rate);

	@Override
	public CommerceTaxFixedRateAddressRel cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}