/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.tax.engine.fixed.model;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 * This class is a wrapper for {@link CommerceTaxFixedRateAddressRel}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceTaxFixedRateAddressRel
 * @generated
 */
public class CommerceTaxFixedRateAddressRelWrapper
	implements CommerceTaxFixedRateAddressRel,
			   ModelWrapper<CommerceTaxFixedRateAddressRel> {

	public CommerceTaxFixedRateAddressRelWrapper(
		CommerceTaxFixedRateAddressRel commerceTaxFixedRateAddressRel) {

		_commerceTaxFixedRateAddressRel = commerceTaxFixedRateAddressRel;
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceTaxFixedRateAddressRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceTaxFixedRateAddressRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put(
			"commerceTaxFixedRateAddressRelId",
			getCommerceTaxFixedRateAddressRelId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("commerceTaxMethodId", getCommerceTaxMethodId());
		attributes.put("CPTaxCategoryId", getCPTaxCategoryId());
		attributes.put("commerceCountryId", getCommerceCountryId());
		attributes.put("commerceRegionId", getCommerceRegionId());
		attributes.put("zip", getZip());
		attributes.put("rate", getRate());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceTaxFixedRateAddressRelId = (Long)attributes.get(
			"commerceTaxFixedRateAddressRelId");

		if (commerceTaxFixedRateAddressRelId != null) {
			setCommerceTaxFixedRateAddressRelId(
				commerceTaxFixedRateAddressRelId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long commerceTaxMethodId = (Long)attributes.get("commerceTaxMethodId");

		if (commerceTaxMethodId != null) {
			setCommerceTaxMethodId(commerceTaxMethodId);
		}

		Long CPTaxCategoryId = (Long)attributes.get("CPTaxCategoryId");

		if (CPTaxCategoryId != null) {
			setCPTaxCategoryId(CPTaxCategoryId);
		}

		Long commerceCountryId = (Long)attributes.get("commerceCountryId");

		if (commerceCountryId != null) {
			setCommerceCountryId(commerceCountryId);
		}

		Long commerceRegionId = (Long)attributes.get("commerceRegionId");

		if (commerceRegionId != null) {
			setCommerceRegionId(commerceRegionId);
		}

		String zip = (String)attributes.get("zip");

		if (zip != null) {
			setZip(zip);
		}

		Double rate = (Double)attributes.get("rate");

		if (rate != null) {
			setRate(rate);
		}
	}

	@Override
	public Object clone() {
		return new CommerceTaxFixedRateAddressRelWrapper(
			(CommerceTaxFixedRateAddressRel)
				_commerceTaxFixedRateAddressRel.clone());
	}

	@Override
	public int compareTo(
		CommerceTaxFixedRateAddressRel commerceTaxFixedRateAddressRel) {

		return _commerceTaxFixedRateAddressRel.compareTo(
			commerceTaxFixedRateAddressRel);
	}

	@Override
	public com.liferay.commerce.model.CommerceCountry getCommerceCountry()
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceTaxFixedRateAddressRel.getCommerceCountry();
	}

	/**
	 * Returns the commerce country ID of this commerce tax fixed rate address rel.
	 *
	 * @return the commerce country ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getCommerceCountryId() {
		return _commerceTaxFixedRateAddressRel.getCommerceCountryId();
	}

	@Override
	public com.liferay.commerce.model.CommerceRegion getCommerceRegion()
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceTaxFixedRateAddressRel.getCommerceRegion();
	}

	/**
	 * Returns the commerce region ID of this commerce tax fixed rate address rel.
	 *
	 * @return the commerce region ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getCommerceRegionId() {
		return _commerceTaxFixedRateAddressRel.getCommerceRegionId();
	}

	/**
	 * Returns the commerce tax fixed rate address rel ID of this commerce tax fixed rate address rel.
	 *
	 * @return the commerce tax fixed rate address rel ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getCommerceTaxFixedRateAddressRelId() {
		return _commerceTaxFixedRateAddressRel.
			getCommerceTaxFixedRateAddressRelId();
	}

	@Override
	public com.liferay.commerce.tax.model.CommerceTaxMethod
			getCommerceTaxMethod()
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceTaxFixedRateAddressRel.getCommerceTaxMethod();
	}

	/**
	 * Returns the commerce tax method ID of this commerce tax fixed rate address rel.
	 *
	 * @return the commerce tax method ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getCommerceTaxMethodId() {
		return _commerceTaxFixedRateAddressRel.getCommerceTaxMethodId();
	}

	/**
	 * Returns the company ID of this commerce tax fixed rate address rel.
	 *
	 * @return the company ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getCompanyId() {
		return _commerceTaxFixedRateAddressRel.getCompanyId();
	}

	@Override
	public com.liferay.commerce.product.model.CPTaxCategory getCPTaxCategory()
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceTaxFixedRateAddressRel.getCPTaxCategory();
	}

	/**
	 * Returns the cp tax category ID of this commerce tax fixed rate address rel.
	 *
	 * @return the cp tax category ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getCPTaxCategoryId() {
		return _commerceTaxFixedRateAddressRel.getCPTaxCategoryId();
	}

	/**
	 * Returns the create date of this commerce tax fixed rate address rel.
	 *
	 * @return the create date of this commerce tax fixed rate address rel
	 */
	@Override
	public Date getCreateDate() {
		return _commerceTaxFixedRateAddressRel.getCreateDate();
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return _commerceTaxFixedRateAddressRel.getExpandoBridge();
	}

	/**
	 * Returns the group ID of this commerce tax fixed rate address rel.
	 *
	 * @return the group ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getGroupId() {
		return _commerceTaxFixedRateAddressRel.getGroupId();
	}

	/**
	 * Returns the modified date of this commerce tax fixed rate address rel.
	 *
	 * @return the modified date of this commerce tax fixed rate address rel
	 */
	@Override
	public Date getModifiedDate() {
		return _commerceTaxFixedRateAddressRel.getModifiedDate();
	}

	/**
	 * Returns the primary key of this commerce tax fixed rate address rel.
	 *
	 * @return the primary key of this commerce tax fixed rate address rel
	 */
	@Override
	public long getPrimaryKey() {
		return _commerceTaxFixedRateAddressRel.getPrimaryKey();
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceTaxFixedRateAddressRel.getPrimaryKeyObj();
	}

	/**
	 * Returns the rate of this commerce tax fixed rate address rel.
	 *
	 * @return the rate of this commerce tax fixed rate address rel
	 */
	@Override
	public double getRate() {
		return _commerceTaxFixedRateAddressRel.getRate();
	}

	/**
	 * Returns the user ID of this commerce tax fixed rate address rel.
	 *
	 * @return the user ID of this commerce tax fixed rate address rel
	 */
	@Override
	public long getUserId() {
		return _commerceTaxFixedRateAddressRel.getUserId();
	}

	/**
	 * Returns the user name of this commerce tax fixed rate address rel.
	 *
	 * @return the user name of this commerce tax fixed rate address rel
	 */
	@Override
	public String getUserName() {
		return _commerceTaxFixedRateAddressRel.getUserName();
	}

	/**
	 * Returns the user uuid of this commerce tax fixed rate address rel.
	 *
	 * @return the user uuid of this commerce tax fixed rate address rel
	 */
	@Override
	public String getUserUuid() {
		return _commerceTaxFixedRateAddressRel.getUserUuid();
	}

	/**
	 * Returns the zip of this commerce tax fixed rate address rel.
	 *
	 * @return the zip of this commerce tax fixed rate address rel
	 */
	@Override
	public String getZip() {
		return _commerceTaxFixedRateAddressRel.getZip();
	}

	@Override
	public int hashCode() {
		return _commerceTaxFixedRateAddressRel.hashCode();
	}

	@Override
	public boolean isCachedModel() {
		return _commerceTaxFixedRateAddressRel.isCachedModel();
	}

	@Override
	public boolean isEscapedModel() {
		return _commerceTaxFixedRateAddressRel.isEscapedModel();
	}

	@Override
	public boolean isNew() {
		return _commerceTaxFixedRateAddressRel.isNew();
	}

	@Override
	public void persist() {
		_commerceTaxFixedRateAddressRel.persist();
	}

	@Override
	public void setCachedModel(boolean cachedModel) {
		_commerceTaxFixedRateAddressRel.setCachedModel(cachedModel);
	}

	/**
	 * Sets the commerce country ID of this commerce tax fixed rate address rel.
	 *
	 * @param commerceCountryId the commerce country ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCommerceCountryId(long commerceCountryId) {
		_commerceTaxFixedRateAddressRel.setCommerceCountryId(commerceCountryId);
	}

	/**
	 * Sets the commerce region ID of this commerce tax fixed rate address rel.
	 *
	 * @param commerceRegionId the commerce region ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCommerceRegionId(long commerceRegionId) {
		_commerceTaxFixedRateAddressRel.setCommerceRegionId(commerceRegionId);
	}

	/**
	 * Sets the commerce tax fixed rate address rel ID of this commerce tax fixed rate address rel.
	 *
	 * @param commerceTaxFixedRateAddressRelId the commerce tax fixed rate address rel ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCommerceTaxFixedRateAddressRelId(
		long commerceTaxFixedRateAddressRelId) {

		_commerceTaxFixedRateAddressRel.setCommerceTaxFixedRateAddressRelId(
			commerceTaxFixedRateAddressRelId);
	}

	/**
	 * Sets the commerce tax method ID of this commerce tax fixed rate address rel.
	 *
	 * @param commerceTaxMethodId the commerce tax method ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCommerceTaxMethodId(long commerceTaxMethodId) {
		_commerceTaxFixedRateAddressRel.setCommerceTaxMethodId(
			commerceTaxMethodId);
	}

	/**
	 * Sets the company ID of this commerce tax fixed rate address rel.
	 *
	 * @param companyId the company ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCompanyId(long companyId) {
		_commerceTaxFixedRateAddressRel.setCompanyId(companyId);
	}

	/**
	 * Sets the cp tax category ID of this commerce tax fixed rate address rel.
	 *
	 * @param CPTaxCategoryId the cp tax category ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCPTaxCategoryId(long CPTaxCategoryId) {
		_commerceTaxFixedRateAddressRel.setCPTaxCategoryId(CPTaxCategoryId);
	}

	/**
	 * Sets the create date of this commerce tax fixed rate address rel.
	 *
	 * @param createDate the create date of this commerce tax fixed rate address rel
	 */
	@Override
	public void setCreateDate(Date createDate) {
		_commerceTaxFixedRateAddressRel.setCreateDate(createDate);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.kernel.model.BaseModel<?> baseModel) {

		_commerceTaxFixedRateAddressRel.setExpandoBridgeAttributes(baseModel);
	}

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge) {
		_commerceTaxFixedRateAddressRel.setExpandoBridgeAttributes(
			expandoBridge);
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		_commerceTaxFixedRateAddressRel.setExpandoBridgeAttributes(
			serviceContext);
	}

	/**
	 * Sets the group ID of this commerce tax fixed rate address rel.
	 *
	 * @param groupId the group ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setGroupId(long groupId) {
		_commerceTaxFixedRateAddressRel.setGroupId(groupId);
	}

	/**
	 * Sets the modified date of this commerce tax fixed rate address rel.
	 *
	 * @param modifiedDate the modified date of this commerce tax fixed rate address rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate) {
		_commerceTaxFixedRateAddressRel.setModifiedDate(modifiedDate);
	}

	@Override
	public void setNew(boolean n) {
		_commerceTaxFixedRateAddressRel.setNew(n);
	}

	/**
	 * Sets the primary key of this commerce tax fixed rate address rel.
	 *
	 * @param primaryKey the primary key of this commerce tax fixed rate address rel
	 */
	@Override
	public void setPrimaryKey(long primaryKey) {
		_commerceTaxFixedRateAddressRel.setPrimaryKey(primaryKey);
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		_commerceTaxFixedRateAddressRel.setPrimaryKeyObj(primaryKeyObj);
	}

	/**
	 * Sets the rate of this commerce tax fixed rate address rel.
	 *
	 * @param rate the rate of this commerce tax fixed rate address rel
	 */
	@Override
	public void setRate(double rate) {
		_commerceTaxFixedRateAddressRel.setRate(rate);
	}

	/**
	 * Sets the user ID of this commerce tax fixed rate address rel.
	 *
	 * @param userId the user ID of this commerce tax fixed rate address rel
	 */
	@Override
	public void setUserId(long userId) {
		_commerceTaxFixedRateAddressRel.setUserId(userId);
	}

	/**
	 * Sets the user name of this commerce tax fixed rate address rel.
	 *
	 * @param userName the user name of this commerce tax fixed rate address rel
	 */
	@Override
	public void setUserName(String userName) {
		_commerceTaxFixedRateAddressRel.setUserName(userName);
	}

	/**
	 * Sets the user uuid of this commerce tax fixed rate address rel.
	 *
	 * @param userUuid the user uuid of this commerce tax fixed rate address rel
	 */
	@Override
	public void setUserUuid(String userUuid) {
		_commerceTaxFixedRateAddressRel.setUserUuid(userUuid);
	}

	/**
	 * Sets the zip of this commerce tax fixed rate address rel.
	 *
	 * @param zip the zip of this commerce tax fixed rate address rel
	 */
	@Override
	public void setZip(String zip) {
		_commerceTaxFixedRateAddressRel.setZip(zip);
	}

	@Override
	public com.liferay.portal.kernel.model.CacheModel
		<CommerceTaxFixedRateAddressRel> toCacheModel() {

		return _commerceTaxFixedRateAddressRel.toCacheModel();
	}

	@Override
	public CommerceTaxFixedRateAddressRel toEscapedModel() {
		return new CommerceTaxFixedRateAddressRelWrapper(
			_commerceTaxFixedRateAddressRel.toEscapedModel());
	}

	@Override
	public String toString() {
		return _commerceTaxFixedRateAddressRel.toString();
	}

	@Override
	public CommerceTaxFixedRateAddressRel toUnescapedModel() {
		return new CommerceTaxFixedRateAddressRelWrapper(
			_commerceTaxFixedRateAddressRel.toUnescapedModel());
	}

	@Override
	public String toXmlString() {
		return _commerceTaxFixedRateAddressRel.toXmlString();
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceTaxFixedRateAddressRelWrapper)) {
			return false;
		}

		CommerceTaxFixedRateAddressRelWrapper
			commerceTaxFixedRateAddressRelWrapper =
				(CommerceTaxFixedRateAddressRelWrapper)object;

		if (Objects.equals(
				_commerceTaxFixedRateAddressRel,
				commerceTaxFixedRateAddressRelWrapper.
					_commerceTaxFixedRateAddressRel)) {

			return true;
		}

		return false;
	}

	@Override
	public CommerceTaxFixedRateAddressRel getWrappedModel() {
		return _commerceTaxFixedRateAddressRel;
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return _commerceTaxFixedRateAddressRel.isEntityCacheEnabled();
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return _commerceTaxFixedRateAddressRel.isFinderCacheEnabled();
	}

	@Override
	public void resetOriginalValues() {
		_commerceTaxFixedRateAddressRel.resetOriginalValues();
	}

	private final CommerceTaxFixedRateAddressRel
		_commerceTaxFixedRateAddressRel;

}