/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.support.web.internal.display.context;

import com.liferay.commerce.constants.CommerceWebKeys;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.user.segment.model.CommerceUserSegmentEntry;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentEntryService;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.ArrayList;
import java.util.List;

import javax.portlet.RenderRequest;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceContextDisplayContext {

	public CommerceContextDisplayContext(
		CommerceUserSegmentEntryService commerceUserSegmentEntryService,
		RenderRequest renderRequest) {

		_commerceUserSegmentEntryService = commerceUserSegmentEntryService;
		_renderRequest = renderRequest;
	}

	public CommerceContext getCommerceContext() {
		return (CommerceContext)_renderRequest.getAttribute(
			CommerceWebKeys.COMMERCE_CONTEXT);
	}

	public List<CommerceUserSegmentEntry> getCommerceUserSegmentEntries()
		throws PortalException {

		List<CommerceUserSegmentEntry> commerceUserSegmentEntries =
			new ArrayList<>();

		CommerceContext commerceContext = getCommerceContext();

		for (long commerceUserSegmentEntryId :
				commerceContext.getCommerceUserSegmentEntryIds()) {

			commerceUserSegmentEntries.add(
				_commerceUserSegmentEntryService.getCommerceUserSegmentEntry(
					commerceUserSegmentEntryId));
		}

		return commerceUserSegmentEntries;
	}

	private final CommerceUserSegmentEntryService
		_commerceUserSegmentEntryService;
	private final RenderRequest _renderRequest;

}