/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipping.engine.fixed.service.impl;

import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.base.CommerceShippingFixedOptionLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceShippingFixedOptionLocalServiceImpl
extends CommerceShippingFixedOptionLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public CommerceShippingFixedOption addCommerceShippingFixedOption(long userId, long groupId, long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, BigDecimal amount, double priority) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long commerceShippingFixedOptionId = this.counterLocalService.increment();
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionPersistence.create(commerceShippingFixedOptionId);
        commerceShippingFixedOption.setGroupId(groupId);
        commerceShippingFixedOption.setCompanyId(user.getCompanyId());
        commerceShippingFixedOption.setUserId(user.getUserId());
        commerceShippingFixedOption.setUserName(user.getFullName());
        commerceShippingFixedOption.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceShippingFixedOption.setNameMap(nameMap);
        commerceShippingFixedOption.setDescriptionMap(descriptionMap);
        commerceShippingFixedOption.setAmount(amount);
        commerceShippingFixedOption.setPriority(priority);
        return (CommerceShippingFixedOption)this.commerceShippingFixedOptionPersistence.update((BaseModel)commerceShippingFixedOption);
    }

    @Deprecated
    public CommerceShippingFixedOption addCommerceShippingFixedOption(long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, BigDecimal amount, double priority, ServiceContext serviceContext) throws PortalException {
        return this.commerceShippingFixedOptionLocalService.addCommerceShippingFixedOption(serviceContext.getUserId(), serviceContext.getScopeGroupId(), commerceShippingMethodId, nameMap, descriptionMap, amount, priority);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CommerceShippingFixedOption deleteCommerceShippingFixedOption(CommerceShippingFixedOption commerceShippingFixedOption) {
        this.commerceShippingFixedOptionPersistence.remove((BaseModel)commerceShippingFixedOption);
        this.commerceShippingFixedOptionRelLocalService.deleteCommerceShippingFixedOptionRels(commerceShippingFixedOption.getCommerceShippingFixedOptionId());
        return commerceShippingFixedOption;
    }

    public void deleteCommerceShippingFixedOptions(long commerceShippingMethodId) {
        this.commerceShippingFixedOptionPersistence.removeByCommerceShippingMethodId(commerceShippingMethodId);
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long commerceShippingMethodId, int start, int end) {
        return this.commerceShippingFixedOptionPersistence.findByCommerceShippingMethodId(commerceShippingMethodId, start, end);
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceShippingFixedOption> orderByComparator) {
        return this.commerceShippingFixedOptionPersistence.findByCommerceShippingMethodId(commerceShippingMethodId, start, end, orderByComparator);
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long companyId, long groupId, long commerceShippingMethodId, String keywords, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, commerceShippingMethodId, keywords, start, end);
        BaseModelSearchResult<CommerceShippingFixedOption> baseModelSearchResult = this.searchCommerceShippingFixedOption(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public int getCommerceShippingFixedOptionsCount(long commerceShippingMethodId) {
        return this.commerceShippingFixedOptionPersistence.countByCommerceShippingMethodId(commerceShippingMethodId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BaseModelSearchResult<CommerceShippingFixedOption> searchCommerceShippingFixedOption(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceShippingFixedOption.class.getName());
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceShippingFixedOption> commerceShippingFixedOptions = this.getCommerceShippingFixedOptions(hits);
            if (commerceShippingFixedOptions == null) continue;
            return new BaseModelSearchResult(commerceShippingFixedOptions, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public CommerceShippingFixedOption updateCommerceShippingFixedOption(long commerceShippingFixedOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, BigDecimal amount, double priority) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionPersistence.findByPrimaryKey(commerceShippingFixedOptionId);
        commerceShippingFixedOption.setNameMap(nameMap);
        commerceShippingFixedOption.setDescriptionMap(descriptionMap);
        commerceShippingFixedOption.setAmount(amount);
        commerceShippingFixedOption.setPriority(priority);
        return (CommerceShippingFixedOption)this.commerceShippingFixedOptionPersistence.update((BaseModel)commerceShippingFixedOption);
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, long commerceShippingMethodId, String keywords, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("commerceShippingMethodId", (Serializable)Long.valueOf(commerceShippingMethodId));
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setKeywords(keywords);
        Sort sort = SortFactoryUtil.getSort(CommerceShippingFixedOption.class, (int)6, (String)"createDate", (String)"DESC");
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceShippingFixedOption> commerceShippingFixedOptions = new ArrayList<CommerceShippingFixedOption>(documents.size());
        for (Document document : documents) {
            long commerceShippingFixedOptionId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceShippingFixedOption commerceShippingFixedOption = this.fetchCommerceShippingFixedOption(commerceShippingFixedOptionId);
            if (commerceShippingFixedOption == null) {
                commerceShippingFixedOption = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceShippingFixedOption.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceShippingFixedOptions == null) continue;
            commerceShippingFixedOptions.add(commerceShippingFixedOption);
        }
        return commerceShippingFixedOptions;
    }
}

