/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipping.engine.fixed.service.impl;

import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceShippingMethodService;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.base.CommerceShippingFixedOptionServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceShippingFixedOptionServiceImpl
extends CommerceShippingFixedOptionServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceShippingFixedOptionServiceImpl.class, (String)"_commerceChannelModelResourcePermission", CommerceChannel.class);
    @ServiceReference(type=CommerceChannelLocalService.class)
    private CommerceChannelLocalService _commerceChannelLocalService;
    @ServiceReference(type=CommerceShippingMethodService.class)
    private CommerceShippingMethodService _commerceShippingMethodService;

    public CommerceShippingFixedOption addCommerceShippingFixedOption(long userId, long groupId, long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, BigDecimal amount, double priority) throws PortalException {
        this._checkCommerceChannelPermissionByGroupId(groupId);
        return this.commerceShippingFixedOptionLocalService.addCommerceShippingFixedOption(userId, groupId, commerceShippingMethodId, nameMap, descriptionMap, amount, priority);
    }

    @Deprecated
    public CommerceShippingFixedOption addCommerceShippingFixedOption(long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, BigDecimal amount, double priority, ServiceContext serviceContext) throws PortalException {
        return this.commerceShippingFixedOptionService.addCommerceShippingFixedOption(serviceContext.getUserId(), serviceContext.getScopeGroupId(), commerceShippingMethodId, nameMap, descriptionMap, amount, priority);
    }

    public void deleteCommerceShippingFixedOption(long commerceShippingFixedOptionId) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOption(commerceShippingFixedOptionId);
        this._checkCommerceChannelPermissionByGroupId(commerceShippingFixedOption.getGroupId());
        this.commerceShippingFixedOptionLocalService.deleteCommerceShippingFixedOption(commerceShippingFixedOption);
    }

    public CommerceShippingFixedOption fetchCommerceShippingFixedOption(long commerceShippingFixedOptionId) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(commerceShippingFixedOptionId);
        if (commerceShippingFixedOption != null) {
            this._checkCommerceChannelPermissionByGroupId(commerceShippingFixedOption.getGroupId());
        }
        return commerceShippingFixedOption;
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long commerceShippingMethodId, int start, int end) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        return this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOptions(commerceShippingMethod.getCommerceShippingMethodId(), start, end);
    }

    public List<CommerceShippingFixedOption> getCommerceShippingFixedOptions(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceShippingFixedOption> orderByComparator) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        return this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOptions(commerceShippingMethod.getCommerceShippingMethodId(), start, end, orderByComparator);
    }

    public int getCommerceShippingFixedOptionsCount(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.getCommerceShippingMethod(commerceShippingMethodId);
        return this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOptionsCount(commerceShippingMethod.getCommerceShippingMethodId());
    }

    public CommerceShippingFixedOption updateCommerceShippingFixedOption(long commerceShippingFixedOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, BigDecimal amount, double priority) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this.commerceShippingFixedOptionLocalService.getCommerceShippingFixedOption(commerceShippingFixedOptionId);
        this._checkCommerceChannelPermissionByGroupId(commerceShippingFixedOption.getGroupId());
        return this.commerceShippingFixedOptionLocalService.updateCommerceShippingFixedOption(commerceShippingFixedOptionId, nameMap, descriptionMap, amount, priority);
    }

    private void _checkCommerceChannelPermissionByGroupId(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "UPDATE");
    }
}

